/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.contract.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.contract.dao.ContractDao;
import com.artfess.yhxt.contract.dao.ContractItemDao;
import com.artfess.yhxt.contract.dao.ContractPaymentDao;
import com.artfess.yhxt.contract.manager.BillOfQuantitiesManager;
import com.artfess.yhxt.contract.manager.ContractItemManager;
import com.artfess.yhxt.contract.manager.ContractManager;
import com.artfess.yhxt.contract.manager.ContractPaymentManager;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.vo.ContractVo;
import com.artfess.yhxt.statistics.vo.Org4ContractVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractManagerImpl
extends BaseManagerImpl<ContractDao, Contract>
implements ContractManager {
    @Resource
    private ContractItemManager itemManager;
    @Resource
    private ContractPaymentManager paymentManager;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    private ContractPaymentDao contractPaymentDao;
    @Resource
    private ContractItemDao contractItemDao;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Autowired
    private YearBudgetManager yearBudgetManager;
    @Autowired
    private YearBudgetDetailedManager yearBudgetDetailedManager;
    @Resource
    private BillOfQuantitiesManager billOfQuantitiesManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;
    @Resource
    BaseContext baseContext;

    @Override
    public List<Org4ContractVO> getContractCount(String year) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4ContractVO> lists = new ArrayList<Org4ContractVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = ContractManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4ContractVO fvo = new Org4ContractVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = ContractManagerImpl.getChild(lists, orgId);
        return this.setCount(lists, year);
    }

    public List<Org4ContractVO> setCount(List<Org4ContractVO> list, String year) {
        Iterator<Org4ContractVO> it = list.iterator();
        while (it.hasNext()) {
            Org4ContractVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO, year);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren(), year);
        }
        return list;
    }

    public Org4ContractVO newCount(List<String> ids, Org4ContractVO orgVO, String year) {
        BigDecimal allMoney = new BigDecimal(0);
        BigDecimal contractMoney = new BigDecimal(0);
        BigDecimal payMoney = new BigDecimal(0);
        BigDecimal finishRate = new BigDecimal(0);
        for (String roadId : ids) {
            QueryWrapper queryWrapperYearBudget = new QueryWrapper();
            queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)roadId);
            queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
            YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
            if (yearBudget != null) {
                allMoney = allMoney.add(yearBudget.getBudgetSum());
            }
            QueryWrapper detailedQueryWrapper = new QueryWrapper();
            detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
            detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            detailedQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
            detailedQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
            detailedQueryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
            detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
            YearBudgetDetailed detaileds = (YearBudgetDetailed)((Object)this.yearBudgetDetailedManager.getOne((Wrapper)detailedQueryWrapper));
            payMoney = payMoney.add(detaileds.getImageProgress().multiply(new BigDecimal(10000)));
            QueryWrapper contractWrapper = new QueryWrapper();
            contractWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)roadId);
            contractWrapper.eq((Object)"IS_DELE_", (Object)"0");
            contractWrapper.orderByDesc((Object)"CREATE_TIME_");
            contractWrapper.last("limit 1");
            Contract contract = (Contract)((Object)this.getOne((Wrapper)contractWrapper));
            if (contract == null) continue;
            contractMoney = contractMoney.add(new BigDecimal(String.valueOf(contract.getContractAmount())));
        }
        orgVO.setAllMoney(allMoney);
        orgVO.setContractMoney(contractMoney);
        orgVO.setPayMoney(payMoney);
        if (!payMoney.equals(BigDecimal.ZERO) && !contractMoney.equals(BigDecimal.ZERO)) {
            finishRate = finishRate.add(payMoney.divide(contractMoney, 2, 0));
        }
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        orgVO.setFinishRate(finishRate);
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            ContractManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4ContractVO> getChild(List<Org4ContractVO> allList, String pCode) {
        ArrayList<Org4ContractVO> returnList = new ArrayList<Org4ContractVO>();
        for (Org4ContractVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(ContractManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<Contract> queryContract(QueryFilter<Contract> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Contract> result = ((ContractDao)this.baseMapper).queryContract((IPage<Contract>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Contract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveContractVo(ContractVo vo) {
        Contract contract = vo.getContract();
        contract.setIsDele("0");
        String rcyhht = this.sysIdentityManager.nextId("rcyhht");
        contract.setUniqueNumber(rcyhht);
        this.save((Object)contract);
        String id = contract.getId();
        if (vo.getItemList().size() > 0) {
            vo.getItemList().forEach(s -> {
                s.setContractId(id);
                this.itemManager.save(s);
            });
        }
        vo.getPaymentList().forEach(s -> {
            s.setContractId(id);
            this.paymentManager.save(s);
        });
        List<Accessory> accessories = vo.getAccessories();
        if (accessories.size() > 0) {
            accessories.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessories);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateContractVo(ContractVo vo) {
        QueryWrapper wrapper;
        Contract contract = vo.getContract();
        this.update((Model)contract);
        String id = contract.getId();
        if (vo.getItemList().size() > 0) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"CONTRACT_ID_", (Object)id);
            this.itemManager.getBaseMapper().delete((Wrapper)wrapper);
            vo.getItemList().forEach(s -> {
                s.setContractId(id);
                this.itemManager.saveOrUpdate(s);
            });
        }
        wrapper = new QueryWrapper();
        wrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        this.paymentManager.getBaseMapper().delete((Wrapper)wrapper);
        if (vo.getPaymentList().size() > 0) {
            vo.getPaymentList().forEach(s -> {
                s.setContractId(id);
                this.paymentManager.saveOrUpdate(s);
            });
        }
        List<Accessory> accessories = vo.getAccessories();
        this.accessoryManager.delAccessoryBySourceId(id);
        if (accessories.size() > 0) {
            accessories.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessories);
        }
        return id;
    }

    @Override
    public void checkUniqueNumber(Contract contract) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (contract.getId() != null) {
            queryWrapper.notIn((Object)"ID_", new Object[]{contract.getId()});
        }
        if (StringUtils.isNotBlank((CharSequence)contract.getUniqueNumber())) {
            queryWrapper.eq((Object)"UNIQUE_NUMBER_", (Object)contract.getUniqueNumber());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)0);
        List list = ((ContractDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("\u552f\u4e00\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    @Override
    public String minioContractUpload(MultipartFile file, String sourceId) {
        Accessory accessory = new Accessory();
        accessory.setSourceId(sourceId);
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            String fileName = file.getOriginalFilename();
            System.out.println(fileName);
            accessory.setName(fileName);
            assert (fileName != null);
            String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
            String url = MinioUtil.uploadRelative((MultipartFile)file, (String)"/contract", (String)name, (String)"yhxt");
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
            System.out.println(ext);
            accessory.setType(ext);
            accessory.setSuffix(ext);
            accessory.setUrl(url);
            accessory.setIsDele("0");
            this.accessoryManager.create((Model)accessory);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void downloadContractUpload(String ids, HttpServletResponse response) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String s1 = ResourceUtils.getURL((String)"classpath:").getPath();
            System.out.println(s1);
            String file = "download/contract";
            File path = new File(file);
            if (!path.exists()) {
                path.mkdirs();
            }
            List<String> idList = Arrays.asList(ids.split(","));
            List accessories = this.accessoryManager.listByIds(idList);
            accessories.forEach(s -> {
                String url = s.getUrl();
                String substring = url.substring(url.lastIndexOf("/"));
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + s.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                System.out.println("contract" + substring);
                MinioUtil.downFile((String)"yhxt", (String)("contract" + substring), (OutputStream)out, (boolean)false);
            });
            ZipUtil.zip((String)file, (Boolean)true);
            String zipPath = file + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)"contract.zip");
            FileUtil.deleteFile((String)zipPath);
        }
    }

    @Override
    public ContractVo getContractById(String id) {
        ContractVo contractVo = new ContractVo();
        Contract contract = (Contract)((Object)this.getById((Serializable)((Object)id)));
        contractVo.setContract(contract);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        List contractPayments = this.contractPaymentDao.selectList((Wrapper)queryWrapper);
        if (contractPayments.size() > 0) {
            contractVo.setPaymentList(contractPayments);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        List contractItems = this.contractItemDao.selectList((Wrapper)wrapper);
        if (contractItems.size() > 0) {
            contractVo.setItemList(contractItems);
        }
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        contractVo.setAccessories(accessoryList);
        return contractVo;
    }

    @Override
    public void minioContractDel(List<String> asList) {
        asList.forEach(s -> this.accessoryManager.minIoRemoveFile((String)s, "contract", "yhxt"));
    }
}

