/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.file.util.CheckFileFormatUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.yhxt.basedata.dao.AccessoryDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccessoryManagerImpl
extends BaseManagerImpl<AccessoryDao, Accessory>
implements AccessoryManager {
    @Override
    public String minioDrawingUpload(MultipartFile file, String sourceId) {
        Accessory accessory = new Accessory();
        accessory.setSourceId(sourceId);
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            String fileName = file.getOriginalFilename();
            System.out.println(fileName);
            accessory.setName(fileName);
            String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
            String url = MinioUtil.upload((MultipartFile)file, (String)"drawing", (String)name, (String)"yhxt");
            String ext = CheckFileFormatUtil.getFileType((FileInputStream)((FileInputStream)file.getInputStream()));
            System.out.println(ext);
            accessory.setType(ext);
            accessory.setSuffix(ext);
            accessory.setUrl(url);
            accessory.setIsDele("0");
            this.create((Model)accessory);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Accessory minIoUpload(MultipartFile file, String bizPath, String fileName, String customBucket, String sourceId) {
        Accessory accessory = new Accessory();
        accessory.setSourceId(sourceId);
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            if (StringUtils.isBlank((CharSequence)fileName)) {
                fileName = file.getOriginalFilename();
            }
            accessory.setName(fileName);
            String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
            String url = MinioUtil.upload((MultipartFile)file, (String)bizPath, (String)name, (String)customBucket);
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
            System.out.println(ext);
            accessory.setType(ext);
            accessory.setSuffix(ext);
            accessory.setUrl(url);
            accessory.setIsDele("0");
            this.create((Model)accessory);
            return accessory;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void minIoDownFile(String ids, String bizPath, String filePath, String customBucket, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idList;
            List accessories;
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            if ((accessories = this.listByIds(idList = Arrays.asList(ids.split(",")))).size() == 1) {
                Accessory accessory = (Accessory)((Object)accessories.get(0));
                String url = accessory.getUrl();
                String substring = url.substring(url.lastIndexOf("/"));
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + accessory.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                MinioUtil.downFile((String)customBucket, (String)(bizPath + substring), (OutputStream)out, (boolean)false);
                HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + accessory.getName()), (String)accessory.getName());
                FileUtil.deleteFile((String)(filePath + "/" + accessory.getName()));
                return;
            }
            accessories.forEach(s -> {
                String url = s.getUrl();
                String substring = url.substring(url.lastIndexOf("/"));
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + s.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                System.out.println("contract" + substring);
                MinioUtil.downFile((String)customBucket, (String)(bizPath + substring), (OutputStream)out, (boolean)false);
            });
            this.zip(filePath, true);
            String zipPath = filePath + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)zipPath.substring(zipPath.lastIndexOf("/") + 1));
            FileUtil.deleteFile((String)zipPath);
        }
    }

    @Override
    public void minIoDownFile(String ids, String bizPath, HttpServletResponse response) throws Exception {
        this.minIoDownFile(ids, bizPath, "download/" + bizPath, "yhxt", response);
    }

    @Override
    public void minIoRemoveFile(String id, String bizPath, String customBucket) {
        Accessory accessory = (Accessory)this.get((Serializable)((Object)id));
        String url = accessory.getUrl();
        String substring = null;
        substring = StringUtils.isBlank((CharSequence)bizPath) ? url.substring(url.lastIndexOf("/") + 1) : bizPath + url.substring(url.lastIndexOf("/"));
        MinioUtil.removeObject((String)customBucket, (String)substring, (boolean)true);
        this.remove((Serializable)((Object)id));
    }

    public void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            ArrayList list = new ArrayList();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir((File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Accessory minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        Accessory accessory = new Accessory();
        String fileName = null;
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String url = MinioUtil.upload((MultipartFile)file, (String)bizPath, (String)name, (String)"yhxt");
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        System.out.println(ext);
        accessory.setType(ext);
        accessory.setSuffix(ext);
        accessory.setUrl(url);
        accessory.setIsDele("0");
        return accessory;
    }

    @Override
    public List<Accessory> getAccessoryBySourceId(String sourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SOURCE_ID_", (Object)sourceId);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        return ((AccessoryDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void delAccessoryBySourceId(String sourceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SOURCE_ID_", (Object)sourceId);
        this.remove((Wrapper)queryWrapper);
    }
}

