/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.entity.BizModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.check.detail.dao.BridgeOftenCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.BridgeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.BridgeOftenCheckDetail;
import com.artfess.yhxt.check.regular.dao.BridgeOftenCheckDao;
import com.artfess.yhxt.check.regular.manager.BridgeOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.CulvertOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.SideSlopeOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.TunnelOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.vo.BridgeOftenCheckVo;
import com.artfess.yhxt.check.regular.vo.CheckReportVO;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BridgeOftenCheckManagerImpl
extends BaseManagerImpl<BridgeOftenCheckDao, BridgeOftenCheck>
implements BridgeOftenCheckManager {
    @Resource
    private BridgeOftenCheckDetailManager bridgeOftenCheckDetailManager;
    @Resource
    private BridgeOftenCheckDetailDao bridgeOftenCheckDetailDao;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private BridgeInformationManager bridgeInformationManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private TunnelOftenCheckManager tunnelOftenCheckManager;
    @Resource
    private BizCulvertInformationManager bizCulvertInformationManager;
    @Resource
    private CulvertOftenCheckManager culvertOftenCheckManager;
    @Resource
    private SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    private SideSlopeOftenCheckManager sideSlopeOftenCheckManager;

    @Override
    public List<CheckReportVO> checkReport(String year, String orgId) {
        ArrayList<CheckReportVO> vos = new ArrayList<CheckReportVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        LocalDateTime now = LocalDateTime.now();
        int month = now.getMonthValue();
        Calendar calendar = Calendar.getInstance();
        for (Road road : roads) {
            CheckReportVO vo = new CheckReportVO();
            vo.setRoadName(road.getName());
            QueryWrapper bridgeWrapper = new QueryWrapper();
            bridgeWrapper.eq((Object)"IS_DELE_", (Object)"0");
            bridgeWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            List bridges = this.bridgeInformationManager.list((Wrapper)bridgeWrapper);
            QueryWrapper tunnelWrapper = new QueryWrapper();
            tunnelWrapper.eq((Object)"IS_DELE_", (Object)"0");
            tunnelWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            List tunnels = this.tunnelInformationManager.list((Wrapper)tunnelWrapper);
            QueryWrapper culvertWrapper = new QueryWrapper();
            culvertWrapper.eq((Object)"IS_DELE_", (Object)"0");
            culvertWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            List culverts = this.bizCulvertInformationManager.list((Wrapper)culvertWrapper);
            QueryWrapper sideWrapper = new QueryWrapper();
            sideWrapper.eq((Object)"IS_DELE_", (Object)"0");
            sideWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            List sides = this.sideSlopeInformationManager.list((Wrapper)sideWrapper);
            vo.setBridgeCount(bridges.size());
            vo.setTunnelCount(tunnels.size());
            vo.setCulvertCount(culverts.size());
            vo.setSideCount(sides.size());
            vo.setAllCount(bridges.size() + tunnels.size() + culverts.size() + sides.size());
            if (bridges.size() > 0) {
                QueryWrapper bridgeCheckWrapper = new QueryWrapper();
                bridgeCheckWrapper.eq((Object)"IS_DELE_", (Object)"0");
                bridgeCheckWrapper.in((Object)"BRIGE_ID_", (Collection)bridges.stream().map(BridgeInformation::getId).collect(Collectors.toList()));
                bridgeCheckWrapper.apply("date_format(CHECK_DATE_,'%Y') = {0}", new Object[]{year});
                List bridgechecks = this.list((Wrapper)bridgeCheckWrapper);
                vo.setBridgeCheckCount(bridgechecks.size());
                ArrayList<BizModel> monthBrideg = new ArrayList<BizModel>();
                for (BizModel check : bridgechecks) {
                    calendar.setTime(check.getCheckDate());
                    if (calendar.get(2) + 1 != month) continue;
                    monthBrideg.add(check);
                }
                vo.setBridgeMonthCheckCount(monthBrideg.size());
            }
            if (tunnels.size() > 0) {
                QueryWrapper tunnelCheckWrapper = new QueryWrapper();
                tunnelCheckWrapper.eq((Object)"IS_DELE_", (Object)"0");
                tunnelCheckWrapper.in((Object)"TUNNEL_ID_", (Collection)tunnels.stream().map(TunnelInformation::getId).collect(Collectors.toList()));
                tunnelCheckWrapper.apply("date_format(CHECK_DATE_,'%Y') = {0}", new Object[]{year});
                List tunnelchecks = this.tunnelOftenCheckManager.list((Wrapper)tunnelCheckWrapper);
                vo.setTunnelCheckCount(tunnelchecks.size());
                ArrayList<BizModel> monthTunnel = new ArrayList<BizModel>();
                for (BizModel check : tunnelchecks) {
                    calendar.setTime(check.getCheckDate());
                    if (calendar.get(2) + 1 != month) continue;
                    monthTunnel.add(check);
                }
                vo.setTunnelMonthCheckCount(monthTunnel.size());
            }
            if (culverts.size() > 0) {
                QueryWrapper culvertCheckWrapper = new QueryWrapper();
                culvertCheckWrapper.eq((Object)"IS_DELE_", (Object)"0");
                culvertCheckWrapper.in((Object)"CULVERT_ID_", (Collection)culverts.stream().map(BizCulvertInformation::getId).collect(Collectors.toList()));
                culvertCheckWrapper.apply("date_format(CHECK_DATE_,'%Y') = {0}", new Object[]{year});
                List culvertchecks = this.culvertOftenCheckManager.list((Wrapper)culvertCheckWrapper);
                vo.setCulvertCheckCount(culvertchecks.size());
                ArrayList<BizModel> monthCulvert = new ArrayList<BizModel>();
                for (BizModel check : culvertchecks) {
                    calendar.setTime(check.getCheckDate());
                    if (calendar.get(2) + 1 != month) continue;
                    monthCulvert.add(check);
                }
                vo.setCulvertMonthCheckCount(monthCulvert.size());
            }
            if (sides.size() > 0) {
                QueryWrapper sideCheckWrapper = new QueryWrapper();
                sideCheckWrapper.eq((Object)"IS_DELE_", (Object)"0");
                sideCheckWrapper.in((Object)"SIDE_SLOPE_ID_", (Collection)sides.stream().map(SideSlopeInformation::getId).collect(Collectors.toList()));
                sideCheckWrapper.apply("date_format(CHECK_DATE_,'%Y') = {0}", new Object[]{year});
                List sidechecks = this.sideSlopeOftenCheckManager.list((Wrapper)sideCheckWrapper);
                vo.setSideCheckCount(sidechecks.size());
                ArrayList<BizModel> monthSide = new ArrayList<BizModel>();
                for (BizModel check : sidechecks) {
                    calendar.setTime(check.getCheckDate());
                    if (calendar.get(2) + 1 != month) continue;
                    monthSide.add(check);
                }
                vo.setSideMonthCheckCount(monthSide.size());
            }
            if (vo.getBridgeCheckCount() > 0) {
                vo.setBridgeMonthRate(new BigDecimal(vo.getBridgeCheckCount()).divide(new BigDecimal(month), 2, 0));
            } else {
                vo.setBridgeMonthRate(BigDecimal.ZERO);
            }
            if (vo.getTunnelCheckCount() > 0) {
                vo.setTunnelMonthRate(new BigDecimal(vo.getTunnelCheckCount()).divide(new BigDecimal(month), 2, 0));
            } else {
                vo.setTunnelMonthRate(BigDecimal.ZERO);
            }
            if (vo.getCulvertCheckCount() > 0) {
                vo.setCulvertMonthRate(new BigDecimal(vo.getCulvertCheckCount()).divide(new BigDecimal(month), 2, 0));
            } else {
                vo.setCulvertMonthRate(BigDecimal.ZERO);
            }
            if (vo.getSideCheckCount() > 0) {
                vo.setSideMonthRate(new BigDecimal(vo.getSideCheckCount()).divide(new BigDecimal(month), 2, 0));
            } else {
                vo.setSideMonthRate(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public PageList<BridgeOftenCheck> queryBridgeOftenCheck(QueryFilter<BridgeOftenCheck> queryFilter) {
        List sorter;
        PageBean pageBean = queryFilter.getPageBean();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (null == (sorter = queryFilter.getSorter()) || sorter.isEmpty()) {
            sorter.add(new FieldSort("CHECK_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        IPage<BridgeOftenCheck> result = ((BridgeOftenCheckDao)this.baseMapper).queryBridgeOftenCheck((IPage<BridgeOftenCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BridgeOftenCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveBridgeOftenCheck(BridgeOftenCheckVo vo) {
        BridgeOftenCheck bridgeOftenCheck = vo.getBridgeOftenCheck();
        bridgeOftenCheck.setIsDele("0");
        this.saveOrUpdate((Object)bridgeOftenCheck);
        vo.getBridgeDetailList().forEach(s -> {
            s.setId(null);
            s.setBridgeOftenCheckId(bridgeOftenCheck.getId());
            this.bridgeOftenCheckDetailManager.save(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = bridgeOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateBridgeOftenCheck(BridgeOftenCheckVo vo) {
        BridgeOftenCheck bridgeOftenCheck = vo.getBridgeOftenCheck();
        this.update((Model)bridgeOftenCheck);
        vo.getBridgeDetailList().forEach(s -> {
            s.setBridgeOftenCheckId(bridgeOftenCheck.getId());
            this.bridgeOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = bridgeOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BridgeOftenCheckVo getBridgeOftenCheckById(String id) {
        BridgeOftenCheckVo checkVo = new BridgeOftenCheckVo();
        BridgeOftenCheck bridgeOftenCheck = (BridgeOftenCheck)((Object)this.getById((Serializable)((Object)id)));
        checkVo.setBridgeOftenCheck(bridgeOftenCheck);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bridgeOftenCheck.getId()), (Object)"BRIDGE_OFTEN_CHECK_ID_", (Object)bridgeOftenCheck.getId());
        List bridgeOftenCheckDetails = this.bridgeOftenCheckDetailDao.selectList((Wrapper)queryWrapper);
        checkVo.setBridgeDetailList(bridgeOftenCheckDetails);
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        checkVo.setAccessories(accessories);
        return checkVo;
    }

    private void saveSiteStatistic(BridgeOftenCheck bridgeOftenCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String brigeId = bridgeOftenCheck.getBrigeId();
        BridgeInformation bridge = (BridgeInformation)((Object)this.bridgeInformationManager.getById((Serializable)((Object)brigeId)));
        siteStatistic.setRoadSegmentId(bridge.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(bridge.getRoadSegmentName());
        siteStatistic.setCompanyId(bridgeOftenCheck.getCompanyId());
        siteStatistic.setCompanyName(bridgeOftenCheck.getCompanyName());
        siteStatistic.setSiteCode(3);
        siteStatistic.setSiteName("\u6865\u6881\u7ecf\u5e38\u68c0\u67e5");
        Date checkDate = bridgeOftenCheck.getCheckDate();
        String month = new SimpleDateFormat("yyyy-MM").format(checkDate);
        siteStatistic.setAccDateMonth(month);
        String year = new SimpleDateFormat("yyyy").format(checkDate);
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)bridge.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)bridge.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)bridge.getCompanyId()), (Object)"COMPANY_ID_", (Object)bridge.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)3);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u6865\u6881\u7ecf\u5e38\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }

    @Override
    public void importExcelData(MultipartFile file, BridgeOftenCheck main) {
        Assert.notNull((Object)((Object)main), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, BridgeOftenCheckDetail.class, (ImportParams)new ImportParams());
            BridgeOftenCheckVo vo = new BridgeOftenCheckVo();
            vo.setBridgeOftenCheck(main);
            vo.setBridgeDetailList(data);
            this.saveBridgeOftenCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

