/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.thirdparty.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.exception.BaseException;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.statistics.manager.CamerasResourceManager;
import com.artfess.yhxt.thirdparty.dao.BizTpBridgeDao;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeHealthManager;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeManager;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.yhxt.thirdparty.model.BizTpBridgeHealth;
import com.artfess.yhxt.thirdparty.vo.BridgeResourceVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgeCountVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgePageVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.artfess.yhxt.util.StreamUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BizTpBridgeManagerImpl
extends BaseManagerImpl<BizTpBridgeDao, BizTpBridge>
implements BizTpBridgeManager {
    @Resource
    BizTpBridgeDao bizTpBridgeDao;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    BaseContext baseContext;
    @Resource
    CamerasResourceManager camerasResourceManager;
    @Resource
    BizTpBridgeHealthManager bizTpBridgeHealthManager;
    @Resource
    BridgeInformationManager bridgeInformationManager;

    @Override
    public BizTpBridge selectByCode(String bridgeCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"BRIDGE_CODE_", (Object)bridgeCode);
        wrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.list((Wrapper)wrapper);
        if (null != list && list.size() > 0) {
            return (BizTpBridge)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public BizTpBridge selectById(String id) {
        BizTpBridge bizTpBridge = this.bizTpBridgeDao.selectByIdNoElse(id);
        return bizTpBridge;
    }

    @Override
    public TpBridgeCountVo getBridgeCount(QueryFilter<BizTpBridge> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(-1);
        queryFilter.setPageBean(pageBean);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BizTpBridge> result = ((BizTpBridgeDao)this.baseMapper).queryBizTpBridge((IPage<BizTpBridge>)this.convert2IPage(pageBean), map, (Wrapper<BizTpBridge>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List list = result.getRecords();
        TpBridgeCountVo countVo = new TpBridgeCountVo();
        if (null != list && list.size() > 0) {
            Map<Integer, List<BizTpBridge>> resultMap = list.stream().collect(Collectors.groupingBy(BizTpBridge::getType));
            List<BizTpBridge> bizTpBridges1 = resultMap.get(1);
            List<BizTpBridge> bizTpBridges2 = resultMap.get(2);
            List<BizTpBridge> bizTpBridges3 = resultMap.get(3);
            List<BizTpBridge> bizTpBridges4 = resultMap.get(4);
            if (null != bizTpBridges1) {
                countVo.setSuspensionCount(bizTpBridges1.size());
            }
            if (null != bizTpBridges2) {
                countVo.setCableStayedCount(bizTpBridges2.size());
            }
            if (null != bizTpBridges3) {
                countVo.setArchCount(bizTpBridges3.size());
            }
            if (null != bizTpBridges4) {
                countVo.setGirderCount(bizTpBridges4.size());
            }
        }
        return countVo;
    }

    @Override
    public PageList<TpBridgePageVo> pageVo(QueryFilter<BizTpBridge> queryFilter) {
        IPage<BizTpBridge> result;
        List rows;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        if (null == (rows = (result = ((BizTpBridgeDao)this.baseMapper).queryBizTpBridge((IPage<BizTpBridge>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizTpBridge>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords()) || rows.isEmpty()) {
            return new PageList();
        }
        List ids = rows.stream().map(e -> e.getBridgeId()).collect(Collectors.toList());
        List bridgeInformations = this.bridgeInformationManager.listByIds(ids);
        Map<String, BridgeInformation> bridgeInformationMap = StreamUtil.toMap(bridgeInformations, BridgeInformation::getId);
        ArrayList<TpBridgePageVo> vos = new ArrayList<TpBridgePageVo>();
        for (BizTpBridge row : rows) {
            TpBridgePageVo tpBridgePageVo = new TpBridgePageVo();
            BeanUtil.copyProperties((Object)((Object)row), (Object)tpBridgePageVo, (String[])new String[0]);
            BridgeInformation information = bridgeInformationMap.get(row.getBridgeId());
            if (null != information) {
                BeanUtil.copyProperties((Object)((Object)information), (Object)tpBridgePageVo, (String[])new String[0]);
            }
            QueryWrapper healthQueryWrapper = new QueryWrapper();
            healthQueryWrapper.eq((Object)"TP_BRIDGE_ID_", (Object)row.getBridgeId());
            List healths = this.bizTpBridgeHealthManager.list((Wrapper)healthQueryWrapper);
            if (null != healths && !healths.isEmpty()) {
                tpBridgePageVo.setState(((BizTpBridgeHealth)((Object)healths.get(healths.size() - 1))).getHealthAssessmentLevel());
            }
            vos.add(tpBridgePageVo);
        }
        PageList pageList = new PageList();
        pageList.setPage(result.getPages());
        pageList.setPageSize(result.getSize());
        pageList.setTotal(result.getTotal());
        pageList.setRows(vos);
        return pageList;
    }

    @Override
    public BridgeResourceVo detailById(String id) {
        BridgeInformation bridgeInformation = (BridgeInformation)((Object)this.bridgeInformationManager.getById((Serializable)((Object)id)));
        if (null == bridgeInformation) {
            throw new BaseException("\u6865\u6881\u4e0d\u5b58\u5728");
        }
        BridgeResourceVo resourceVo = new BridgeResourceVo();
        resourceVo.setBridgeInformation(bridgeInformation);
        QueryWrapper queryWrapper = new QueryWrapper();
        String name = bridgeInformation.getName();
        String substring = name.substring(0, 2);
        queryWrapper.like((Object)"NAME_", (Object)substring);
        List list = this.camerasResourceManager.list((Wrapper)queryWrapper);
        resourceVo.setResources(list);
        QueryWrapper healthQueryWrapper = new QueryWrapper();
        healthQueryWrapper.eq((Object)"TP_BRIDGE_ID_", (Object)id);
        List healths = this.bizTpBridgeHealthManager.list((Wrapper)healthQueryWrapper);
        if (null != healths && !healths.isEmpty()) {
            resourceVo.setCount(healths.size());
            resourceVo.setHealthAssessmentLevel(((BizTpBridgeHealth)((Object)healths.get(healths.size() - 1))).getHealthAssessmentLevel());
        }
        return resourceVo;
    }
}

