/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.task.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionVo;
import com.artfess.yhxt.task.dao.TaskAlreadyHandleHistoryDao;
import com.artfess.yhxt.task.manager.TaskAlreadyHandleHistoryManager;
import com.artfess.yhxt.task.model.TaskAlreadyHandleHistory;
import com.artfess.yhxt.task.vo.TaskAlreadyHandleHistoryVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TaskAlreadyHandleHistoryManagerImpl
extends BaseManagerImpl<TaskAlreadyHandleHistoryDao, TaskAlreadyHandleHistory>
implements TaskAlreadyHandleHistoryManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserManager userManager;

    @Override
    public PageList<TaskAlreadyHandleHistoryVo> queryTaskWaitHandleHistory(QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        String userId = this.baseContext.getCurrentUserId();
        String userAccout = this.baseContext.getCurrentUserAccout();
        String userName = this.baseContext.getCurrentUserName();
        LocalDateTime time = LocalDateTime.now();
        String deptId = this.baseContext.getCurrentDeptId();
        String deptName = this.baseContext.getCurrentDeptName();
        String sendDeptName = this.baseContext.getCurrentDeptName();
        queryFilter.addFilter("RECEIVE_USER_ID", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("RECEIVE_LOGIN_NAME", (Object)userAccout, QueryOP.EQUAL);
        IPage<TaskAlreadyHandleHistoryVo> result = ((TaskAlreadyHandleHistoryDao)this.baseMapper).queryTaskWaitHandleHistory((IPage<TaskAlreadyHandleHistory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskAlreadyHandleHistory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (TaskAlreadyHandleHistoryVo record : records) {
            SiteInspectionVo siteInspectionVo = record.getSiteInspectionVo();
            String rummagerId = siteInspectionVo.getRummagerId();
            List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
            QueryWrapper userQueryWrapper = new QueryWrapper();
            userQueryWrapper.in((Object)"ID_", rummagerIds);
            List users = this.userManager.getBaseMapper().selectList((Wrapper)userQueryWrapper);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                String fullname = user.getFullname();
                if (i == 0) {
                    sb.append(fullname);
                    continue;
                }
                sb.append(",").append(fullname);
            }
            siteInspectionVo.setRummagerName(sb.toString());
            String recorderId = siteInspectionVo.getRecorderId();
            if (!StringUtils.isNotEmpty((CharSequence)recorderId)) continue;
            User recorderUser = (User)this.userManager.getById((Serializable)((Object)recorderId));
            siteInspectionVo.setRecorderName(recorderUser.getFullname());
        }
        return new PageList(result);
    }

    @Override
    public PageList<TaskAlreadyHandleHistory> queryTaskWaitHandleLog(QueryFilter<TaskAlreadyHandleHistory> queryFilter) {
        IPage<TaskAlreadyHandleHistory> result = ((TaskAlreadyHandleHistoryDao)this.baseMapper).queryTaskWaitHandleLog((IPage<TaskAlreadyHandleHistory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskAlreadyHandleHistory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

