/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.specialcheck.vo.DefaultBpmCheckOpinionVo;
import com.artfess.yhxt.specialcheck.vo.SiteDiseaseVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspecionReportVO;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionDiseaseVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionTaskVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionVo;
import com.artfess.yhxt.specialcheck.vo.SiteTaskVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/siteInspection/v1/"})
@Api(tags={"\u5de1\u68c0\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class SiteInspectionController
extends BaseController<SiteInspectionManager, SiteInspection> {
    @Resource
    private RoadManager roadManager;

    @RequestMapping(value={"/getReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u4fe1\u606f", httpMethod="POST")
    public List<SiteInspecionReportVO> getReport(String year, String orgId) {
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SiteInspecionReportVO> vos = new ArrayList<SiteInspecionReportVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        int day = 0;
        int month = 0;
        if (now.getYear() == Integer.valueOf(year).intValue()) {
            day += now.getDayOfYear();
            month += now.getMonthValue();
        } else {
            day += 365;
            month += 12;
        }
        for (Road road : roads) {
            SiteInspecionReportVO vo = new SiteInspecionReportVO();
            int dayCount = 0;
            int nightCount = 0;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            queryWrapper.apply("date_format(CREATE_TIME_,'%Y') = {0}", new Object[]{year});
            List list = ((SiteInspectionManager)this.baseService).list((Wrapper)queryWrapper);
            dayCount = list.stream().filter(s -> s.getType() == 1).collect(Collectors.toList()).size();
            nightCount = list.stream().filter(s -> s.getType() == 2).collect(Collectors.toList()).size();
            vo.setRoadName(road.getName());
            vo.setDayCount(dayCount);
            vo.setNightCount(nightCount);
            vo.setDayRate(new BigDecimal(dayCount).divide(new BigDecimal(day), 2, 4));
            vo.setNightRate(new BigDecimal(nightCount).divide(new BigDecimal(month), 2, 4));
            vos.add(vo);
        }
        return vos;
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5de1\u68c0\u7ba1\u7406", httpMethod="POST")
    public PageList<SiteInspectionVo> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SiteInspection> queryFilter) {
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        if (null == sorter || sorter.isEmpty()) {
            sorter.add(new FieldSort("ID_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        PageList<SiteInspectionVo> pageList = ((SiteInspectionManager)this.baseService).querySiteInspection(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/saveSiteInspectionSpecial"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f", httpMethod="POST")
    public CommonResult<SiteInspection> saveSiteInspection(@ApiParam(name="siteInspection", value="\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f\u5bf9\u8c61") @RequestBody SiteInspection siteInspection) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((CharSequence)siteInspection.getId())) {
            siteInspection.setIsDele("0");
            ((SiteInspectionManager)this.baseService).create((Model)siteInspection);
        } else {
            ((SiteInspectionManager)this.baseService).update((Model)siteInspection);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)siteInspection);
    }

    @RequestMapping(value={"/updateSiteInspection"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f", httpMethod="POST", notes="\u903b\u8f91\u5220\u9664\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f")
    public CommonResult<String> updateSiteInspection(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((SiteInspectionManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f")
    public SiteDiseaseVo get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((SiteInspectionManager)this.baseService).getSiteInspectionById(id);
    }

    @RequestMapping(value={"getSiteInspectionStatus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u5de5\u5355\u72b6\u6001TEST", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u5de5\u5355\u72b6\u6001TEST")
    public PageList<DefaultBpmCheckOpinionVo> getSiteInspectionStatus(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((SiteInspectionManager)this.baseService).getSiteInspectionStatus(queryFilter);
    }

    @RequestMapping(value={"getSiteInspectionTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u5de5\u5355\u72b6\u6001", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u5de5\u5355\u72b6\u6001")
    public PageList<SiteInspectionTaskVo> getSiteInspectionTask(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((SiteInspectionManager)this.baseService).getSiteInspectionTask(queryFilter);
    }

    @RequestMapping(value={"/saveVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de1\u68c0\u7ba1\u7406\u4fe1\u606fVo", httpMethod="POST")
    public CommonResult<SiteInspectionDiseaseVo> saveSiteDiseaseVo(@ApiParam(name="siteInspection", value="\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f\u5bf9\u8c61") @RequestBody SiteInspectionDiseaseVo vo) throws Exception {
        SiteInspectionDiseaseVo siteInspectionDiseaseVo = ((SiteInspectionManager)this.baseService).saveSiteDiseaseVo(vo);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)siteInspectionDiseaseVo);
    }

    @RequestMapping(value={"/startSiteInspectionSpecial"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u5de1\u68c0\u5de5\u5355\u4fe1\u606f", httpMethod="POST")
    public CommonResult<SiteInspection> startSiteInspectionSpecial(@ApiParam(name="siteInspection", value="\u5de1\u68c0\u7ba1\u7406\u4fe1\u606f\u5bf9\u8c61") @RequestBody SiteInspection siteInspection) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        SiteInspection returnVo = ((SiteInspectionManager)this.baseService).saveSite(siteInspection);
        if (returnVo != null) {
            if ("1".equals(returnVo.getId())) {
                return new CommonResult(true, "\u4fee\u6539\u6210\u529f", (Object)siteInspection);
            }
            return new CommonResult(true, msg, (Object)returnVo);
        }
        return new CommonResult(false, "\u4efb\u52a1\u5df2\u63a5\u53d7\u65e0\u6cd5\u4fee\u6539", null);
    }

    @RequestMapping(value={"/updateSiteInspectionSpecial"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u5de1\u68c0\u72b6\u6001", httpMethod="POST")
    public CommonResult<SiteInspection> updateSiteInspectionSpecial(@ApiParam(name="siteTaskVo", value="\u5f85\u529evo") @RequestBody SiteTaskVo siteTaskVo) throws Exception {
        ((SiteInspectionManager)this.baseService).updateSitestatus(siteTaskVo);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/getJsonTaskHistory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5de1\u68c0\u5df2\u529e", httpMethod="POST")
    public PageList<SiteInspectionVo> getJsonTaskHistory(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SiteInspection> queryFilter) {
        queryFilter.addFilter("a.is_dele_", (Object)"0", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        if (null == sorter || sorter.isEmpty()) {
            sorter.add(new FieldSort("ID_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        PageList<SiteInspectionVo> pageList = ((SiteInspectionManager)this.baseService).queryTaskHistory(queryFilter);
        return pageList;
    }
}

