/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.config;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.util.AppUtil;
import com.artfess.sysConfig.config.SQLRowSetOracleResultSetExtractor;
import com.artfess.sysConfig.model.TableField;
import com.baomidou.mybatisplus.core.enums.IEnum;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MySqlInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MySqlInterceptor.class);
    private Logger logger = LoggerFactory.getLogger(MySqlInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String namespace = mappedStatement.getId();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String export = request.getParameter("export");
        if ("field".equals(export)) {
            HttpServletResponse response = attributes.getResponse();
            Object parameter1 = null;
            if (invocation.getArgs().length > 1) {
                parameter1 = invocation.getArgs()[1];
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameter1);
            String sql = boundSql.getSql().replaceAll("\\s+", " ").toLowerCase();
            ArrayList parameterMappings = new ArrayList(boundSql.getParameterMappings());
            Object parameterObject = boundSql.getParameterObject();
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            try {
                this.sqlParser(metaObject);
                String parameter = "null";
                MetaObject newMetaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                    String propertyName = parameterMapping.getProperty();
                    if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                        parameter = MySqlInterceptor.getParameterValue(parameterObject);
                    } else if (newMetaObject.hasGetter(propertyName)) {
                        parameter = MySqlInterceptor.getParameterValue(newMetaObject.getValue(propertyName));
                    } else if (boundSql.hasAdditionalParameter(propertyName)) {
                        parameter = MySqlInterceptor.getParameterValue(boundSql.getAdditionalParameter(propertyName));
                    }
                    sql = sql.replaceFirst("\\?", parameter);
                }
            }
            catch (Exception e) {
                log.error(String.format("intercept sql error: [%s]", sql), (Throwable)e);
            }
            JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            List<TableField> fieldList = this.getSqlFields(jdbcTemplate, sql);
            ServletOutputStream output = response.getOutputStream();
            JSONObject map = new JSONObject();
            map.put("sql", fieldList);
            output.write(map.toString().getBytes());
            output.flush();
            return null;
        }
        Object result = invocation.proceed();
        return result;
    }

    public ResultSetExtractor<?> getResultSetExtractor() {
        return new SQLRowSetOracleResultSetExtractor();
    }

    public List<TableField> getSqlFields(JdbcTemplate jdbcTemplate, String sql) {
        if (sql.indexOf("update") != -1 || sql.indexOf("delete") != -1 || sql.indexOf("truncate") != -1 || sql.indexOf("create") != -1 || sql.indexOf("select") != 0) {
            throw new ApplicationException("SQL\u8bed\u53e5\u53ea\u80fd\u662f\u67e5\u8be2\u8bed\u53e5\u3002");
        }
        SqlRowSet srs = (SqlRowSet)jdbcTemplate.query(sql, this.getResultSetExtractor());
        ArrayList<TableField> columnList = new ArrayList<TableField>();
        String queryClumn = "select column_comment from information_schema.columns where table_schema =? and table_name=? and column_name=?";
        try {
            SqlRowSetMetaData rsmd = srs.getMetaData();
            for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                String fieldName = rsmd.getColumnName(i).toLowerCase();
                String tableName = rsmd.getTableName(i).toLowerCase();
                String dataType = rsmd.getColumnTypeName(i).toLowerCase();
                String dataBase = rsmd.getCatalogName(i).toLowerCase();
                String fieldDesc = "";
                try {
                    fieldDesc = (String)jdbcTemplate.queryForObject(queryClumn, new Object[]{dataBase, tableName, fieldName}, String.class);
                }
                catch (EmptyResultDataAccessException e) {
                    System.out.println("**********" + fieldName);
                }
                TableField field = new TableField();
                field.setFieldDesc(fieldDesc);
                field.setTableName(tableName);
                field.setDataType(dataType);
                field.setFieldName(fieldName);
                columnList.add(field);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("\u89e3\u6790SQL\u51fa\u9519" + e.getMessage());
        }
        return columnList;
    }

    private static String getParameterValue(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof Number) {
            return param.toString();
        }
        String value = null;
        if (param instanceof String) {
            value = param.toString();
        } else if (!(param instanceof Date)) {
            value = param instanceof IEnum ? String.valueOf(((IEnum)param).getValue()) : param.toString();
        }
        return StringUtils.quotaMark((Object)value);
    }

    public Object plugin(Object o) {
        if (o instanceof StatementHandler) {
            return Plugin.wrap((Object)o, (Interceptor)this);
        }
        return o;
    }

    public void setProperties(Properties properties) {
    }
}

