package com.artfess.form.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.FormField;
import com.artfess.form.persistence.dao.FormFieldDao;
import com.artfess.form.persistence.manager.FormFieldManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class FormFieldManagerImpl extends BaseManagerImpl<FormFieldDao, FormField> implements FormFieldManager {

    @Override
    public List<FormField> getByFormId(String formId) {
        return baseMapper.getByFormId(formId);
    }

    @Override
    public List<FormField> getOnlyByFormId(String formId) {
        return baseMapper.getOnlyByFormId(formId);
    }

    @Override
    public List<FormField> getByGroupId(String groupId) {
        return baseMapper.getByGroupId(groupId);
    }

    @Override
    @Transactional
    public void delByMainId(String formId) {
        baseMapper.delByMainId(formId);
    }

    @Override
    public List<FormField> getExtByFormId(String formId) {
        return baseMapper.getExtByFormId(formId);
    }

    @Override
    public List<FormField> getByboDefId(String boDefId) {
        return baseMapper.getByboDefId(boDefId);
    }

    @Override
    public List<FormField> getByFormIdAndBoDefId(String formId, String boDefId) {
        return baseMapper.getByFormIdAndBoDefId(formId, boDefId);
    }

    @Override
    @Transactional
    public void removeByAttrId(String attrId) {
        baseMapper.removeByAttrId(attrId);
    }

    @Override
    public List<FormField> getNoAttrByFormId(String formId) {
        return baseMapper.getNoAttrByFormId(formId);
    }
}
