package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.form.model.ComponentFunctionEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;


import java.util.List;

/**
 * @program: cqgs
 * @Date: 2020/9/26 15:36
 * @Author: ZQF
 * @Description: 建模引擎-元件管理-取值函数
 */
public interface ComponentFunctionManager extends BaseManager<ComponentFunctionEntity> {

    /**
    * @Description: 新增取值函数信息
    * @param componentFunctionEntity
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2020/9/26 15:41
    */
    String insertComponentFunction(ComponentFunctionEntity componentFunctionEntity);

    /**
    * @Description: 修改取值函数信息
    * @param componentFunctionEntity
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2020/9/26 15:42
    */
    String updateComponentFunction(ComponentFunctionEntity componentFunctionEntity);

    /**
    * @Description: 根据ID查询取值函数详情
    * @param id
    * @Return: com.sysplat.sys.modeling.components.entity.ComponentFunctionEntity
    * @Author: ZQF
    * @Date: 2020/9/26 15:42
    */
    ComponentFunctionEntity loadComponentFunction(String id);

    /**
    * @Description: 根据ID批量删除取值函数信息
    * @param ids
    * @Return: java.lang.Integer
    * @Author: ZQF
    * @Date: 2020/9/26 15:42
    */
    Integer deleteComponentFunction(String ids);

    /**
    * @Description: 查询取值函数信息（不分页）
    * @param componentFunctionEntity
    * @Return: java.util.List<com.sysplat.sys.modeling.components.entity.ComponentFunctionEntity>
    * @Author: ZQF
    * @Date: 2020/9/26 16:20
    */
    List<ComponentFunctionEntity> queryComponentFunction(ComponentFunctionEntity componentFunctionEntity);

    /**
    * @Description: 分页查询取值函数信息
    * @param pageRequest
    * @Return: java.util.List<com.sysplat.sys.modeling.components.entity.ComponentFunctionEntity>
    * @Author: ZQF
    * @Date: 2020/9/26 15:44
    */
    //Page<ComponentFunctionEntity> slicedQueryComponentFunction(BasePage<ComponentFunctionEntity> pageRequest);

    /**
    * @Description: 批量修改状态
    * @param ids
    * @param status
    * @Return: void
    * @Author: ZQF
    * @Date: 2020/10/15 15:01
    */
    void updateComponentFunctionStatus(String ids, Integer status);
}
