package com.artfess.base.constants;

import com.artfess.base.cache.setting.CacheSetting;

/**
 * 缓存key 管理
 * @author liyg
 *
 */
public interface CacheKeyConst {
	
	/**
	 * 用户菜单缓存key
	 */
	String EIP_SYS_USERMENU = "bpm:sys:userMenu";
	
	/**
	 * 后台方法和角色的关系
	 * 在对资源授权时操作时需要清空方法和角色的缓存
	 */
	String EIP_SYS_METHOD_AUTH_KEY = "SYS_METHOD_ROLE_AUTH";
	String EIP_SYS_METHOD_AUTH = "bpm:sys:methodAuth";
	
	/**
	 * 系统日志配置的缓存key 是否开始保存日志
	 * SYS_LOGS_SETTING_STATUS + 微服务名称
	 */
	String EIP_SYS_LOGS_SETTING_STATUS_KEY = "SYS_LOGS_SETTING_STATUS";
	String EIP_SYS_LOGS_SETTING_STATUS = "bpm:sys:logsSettingStatus";
	
	/**
	 * 系统日志配置的缓存key  保留天数
	 * SYS_LOGS_SETTING_SAVE_DAY + 微服务名称
	 */
	String EIP_SYS_LOGS_SETTING_DAY_KEY = "SYS_LOGS_SETTING_SAVE_DAY";
	String EIP_SYS_LOGS_SETTING_DAY = "bpm:sys:logsSettingDay";
	
	
	/**
	 * 系统数据权限缓存key
	 */
	String EIP_SYS_DATA_PERMISSION_KEY = "DATA_PERMISSION";
	String EIP_SYS_DATA_PERMISSION = "bpm:sys:dataPermission";
	
	/**
	 * uc模块中按照用户账号缓存数据
	 */
	String EIP_UC_USER_ACCOUNT = "bpm:uc:userAccount";
	/**
	 * uc-api-impl模块中按照用户账号缓存数据
	 */
	String EIP_UC_USER_NAME = "bpm:uc:userName";
	/**
	 * uc-api-impl模块中按照用户ID缓存数据
	 */
	String EIP_UC_USER_ID = "bpm:uc:userId";
	
	/**
	 * 用户的主组织
	 */
	String EIP_UC_USER_MAIN_ORG = "bpm:uc:userMainOrg";
	
	/**
	 * 用户的主组织
	 */
	String EIP_UC_USER_POST= "bpm:uc:userPost";
	
	
	
	/**
	 * 用户的token
	 */
	String EIP_UC_USER_TOKEN = "bpm:uc:userToken";
	
	
	
	/**
	 * 国际化资源语种key
	 */
	String EIP_I18N_MESSAGE_TYPE_KEY = "I18N_MESSAGE_TYPE";
	/**
	 * 国际化资源语种
	 */
	String EIP_I18N_MESSAGE_TYPE = "bpm:i18n:messageType";
	
	/**
	 * 国际化资源
	 */
	String EIP_I18N_RESOURCES = "bpm:i18n:resources";
	CacheSetting EIP_I18N_RESOURCES_CACHESETTING = CacheSetting.buildDefault("国际化资源");
	
	/**
	 * 数据脱敏规则
	 */
	String EIP_SYS_DATA_SENSITIVE = "bpm:sys:dataSensitive";
	
	/**
	 * 系统属性
	 */
	String EIP_SYS_PROPS = "bpm:sys:props";
	
	/**
	* 应用中心用户权限菜单
	* */
	String EIP_SYS_APP_AUTH_MENU = "bpm:sys:appAuthMenu";
	
	
	/**
	 * 流程定义对象缓存key
	 */
	String EIP_BPM_PROCESS_DEF ="bpm:bpm:processDef";
	
	/**
	 * activiti流程对象缓存key
	 */
	String EIP_BPM_PROCESS_ENTITY ="bpm:bpm:processEntity";
	
	/**
	 * 流程定义对象缓存key
	 */
	String EIP_BPM_DEFINITION ="bpm:bpm:definition";
	
	/**
	 * 流程定义BPMN_ID缓存key
	 */
	String EIP_BPM_DEFINITION_BPMN_ID ="bpm:bpm:definitionBpmnId";
	
	
	/**
	 * 流程定义FLOW_KEY 缓存key
	 */
	String EIP_BPM_DEFINITION_FLOW_KEY ="bpm:bpm:definitionFlowKey";
	
	
	/**
	 * 流程定义导入xml缓存key
	 */
	String EIP_BPM_IMPORT_FILE ="bpm:bpm:importFile";
	
	
	
	/**
	 * 流程表单缓存key
	 */
	String EIP_FORM_BPM_FORM ="bpm:form:bpmForm";
	
	String EIP_FORM_DATATEMPLATE_IMPORT_FILE="bpm:form:datatemplateImportFile";
	
	String EIP_FORM_IMPORT_FILE="bpm:form:importFile";
	
	
	/**
	 * 流程表单缓存key
	 */
	String EIP_FORM_BODEF_ALIAS ="bpm:form:boDefAlias";

	/**
	 * SYS_DICTIONARY_KEY 单个系统字典key
	 */
	String  SYS_DICTIONARY_KEY="sys:dictionary:";

	/**
	 * sys_dict_all 系统所有字典信息key
	 */
	String  SYS_DICT_ALL="sys:dict:all";

	/**
	 * 字典信息缓存
	 */
	String SYS_DICT_CACHE = "sys:cache:dict";
	
	
}
