package com.artfess.cqxy.projectManagement.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelMenuManager;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnelMenu;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelMenuVo;
import com.artfess.sysConfig.persistence.manager.SysRoleAuthManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 项目人员菜单中间表(ProjectPersonnelMenuMenu)表控制层
 *
 * @author basli
 * @since 2022年5月30日12:55:32
 */
@Slf4j
@RestController
@Api(tags = "项目管理-项目人员菜单接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/projectManagement/projectPersonnelMenu/v1")
public class ProjectPersonnelMenuController {


    @Resource
    private ProjectPersonnelMenuManager projectPersonnelMenuManager;
    /**
     * 保存数据
     * @param projectPersonnelMenuVo 实体对象
     * @return 新增结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存数据",notes = "约定可以将多个人员ID放到一个personnelId中，以英文逗号隔开，后端做批量新增",httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "dirObject", value = "目录管理信息表对象") @RequestBody ProjectPersonnelMenuVo projectPersonnelMenuVo) {
        Assert.notNull(projectPersonnelMenuVo, "数据不能为空！");
        projectPersonnelMenuManager.create(projectPersonnelMenuVo);
        return new CommonResult<String>(true, "菜单授权成功");
    }


    @RequestMapping(value = "/getAllMenuByProject", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取前台树形全部菜单（用于授权菜单时使用）", httpMethod = "GET", notes = "根据项目ID和用户获得角色树形菜单（用于授权菜单时使用）")
    public ArrayList<Map<String, Object>> getAllMenuRoleAlias(@ApiParam(name = "projectId", value = "项目ID", required = true) @RequestParam String projectId,
                                                              @ApiParam(name = "userId", value = "人员ID", required = true) @RequestParam String userId) throws Exception {
        return (ArrayList<Map<String, Object>>) projectPersonnelMenuManager.getAllMenuByProject(projectId, userId, null);
    }


    @RequestMapping(value = "/getCurrentUserMenuByProjectId")
    @ApiOperation(value = "根据项目ID获取当前用户的菜单", httpMethod = "POST", notes = "根据项目ID获取当前用户的菜单")
    public @ResponseBody
    CommonResult<List<SysMenu>> getCurrentUserMenuByProjectId(
            @ApiParam(name = "projectId", value = "项目ID", required = true) @RequestParam String projectId) throws Exception {
        CommonResult<List<SysMenu>> commonResult = new CommonResult<List<SysMenu>>(true, "根据项目ID获取当前用户的菜单");
        List<SysMenu> menuByProject = projectPersonnelMenuManager.getCurrentUserMenuByProject(projectId, "front_menu");
        commonResult.setValue(menuByProject);
        return commonResult;
    }
}
