package com.artfess.cqxy.processManagermant.dao;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import com.artfess.cqxy.processManagermant.vo.ProgressManageTotalVo;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.processManagermant.model.ProgressManage;

/**
 * 过程管理 - 进度管理(BizProgressManage)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-04 16:49:30
 */
public interface ProgressManageDao extends BaseMapper<ProgressManage> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProgressManage getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ProgressManage> queryAllByPage(IPage<ProgressManage> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProgressManage> convert2Wrapper);

    /**
     * 根据条件查询每月的投资金额
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);

    /**
     * 根据项目ID和审定日期查询已拨款额(所有已拨款)
     * @param projectId
     * @param registerDate
     * @return
     */
    BigDecimal getAmountAppropriatedl(@Param("projectId")String projectId, @Param("registerDate")String registerDate,
                                      @Param("contractId")String contractId);

   BigDecimal getAmountAppropriatedlExceptId(@Param("projectId")String projectId, @Param("registerDate")String registerDate,
                                      @Param("contractId")String contractId,@Param("id") String id);

    /**
     * 根据项目ID和审定日期查询已拨款额（工程款已拨款额）
     * @param projectId
     * @param registerDate
     * @return
     */
    BigDecimal getAppropriatedl(@Param("projectId")String projectId, @Param("registerDate") String registerDate);

    /**
     * 根据项目ID和审定日期查询已拨款额（除开工程款以外的已拨款额）
     * @param projectId
     * @param registerDate
     * @return
     */
    BigDecimal getNotAppropriatedl(@Param("projectId")String projectId, @Param("registerDate")String registerDate);

    /**
     * 根据项目ID查询支付汇总数据（查看界面）
     * @param vo
     * @return
     */
    ProgressManageTotalVo getProgressManageTotalByProjectId(@Param("vo")ProgressManageTotalVo vo);

    /**
     * 通过项目ID查询项目支付总和
     * @param projectId
     * @return
     */
    BigDecimal geTamountAppropriatedTotalByProjectId(@Param("projectId")String projectId);


    /**
     * 通过项目ID查询项目支付总和
     * @param projectId
     * @return
     */
    BigDecimal geTamountAppropriatedTotalByProjectIdAndPurpose(@Param("projectId")String projectId, @Param("purpose")Integer purpose);

    BigDecimal getTwoPrice(@Param("pid")String pid, @Param("purposes")List<String> purposes);

    List<String> selectProjectIds();


    List<ProgressManage> selectByProjectId(@Param("projectId")String projectId);

    BigDecimal selectAmountAppropriated(@Param("projectId")String projectId,
                                        @Param("contractId")String contractId,
                                        @Param("registerDate")Date registerDate,
                                        @Param("id")String id);

}

