package com.artfess.cqxy.feasiblePlan.dao;

import java.util.List;
import java.util.Map;

import com.artfess.cqxy.bidManagement.model.BidManagement;
import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.artfess.cqxy.feasiblePlan.model.PlanningUseLand;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;

/**
 * 规划许可-选址表(BizPlanningSelectionSite)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-15 09:32:24
 */
public interface PlanningSelectionSiteDao extends BaseMapper<PlanningSelectionSite> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    PlanningSelectionSite getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<PlanningSelectionSite> queryAllByPage(IPage<PlanningSelectionSite> convert2IPage, @Param(Constants.WRAPPER) Wrapper<PlanningSelectionSite> convert2Wrapper);

}

