package com.artfess.cqxy.constructionPermit.dao;

import com.artfess.cqxy.constructionPermit.model.ConstructionPermitNew;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 施工许可表(BizConstructionPermitNew)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-23 10:24:54
 */
public interface ConstructionPermitNewDao extends BaseMapper<ConstructionPermitNew> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ConstructionPermitNew getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ConstructionPermitNew> queryAllByPage(IPage<ConstructionPermitNew> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ConstructionPermitNew> convert2Wrapper);

}

