package com.artfess.application.persistence.manager;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @program: edp
 * @Date: 2021/3/16 9:35
 * @Author: llj
 * @Description:
 */
public interface ElaticsearchLogManager {

    /**
     * 分页查询日志信息
     * @param pageNum
     * @param pageSize
     * @return
     */
    Map<String,Object> queryDataByQueryBuilder(Integer pageNum, Integer pageSize);


    /**
     *  通过ID查询日志信息
     * @param id
     * @return
     */
    List<Map<String, Object>> queryApplicationLogById(String id);

    /**
     * es查询错误日志信息
     * @param user
     * @param startDate
     * @param endDate
     * @param pageNum
     * @param pageSize
     * @return
     */
    Map<String, Object> queryErrorByQueryBuilder(String user, String startDate, String endDate, Integer pageNum, Integer pageSize);

    /**
     * es分页查询业务日志信息
     * @param startDate 開始時間
     * @param endDate 結束時間
     * @param pageNum
     * @param pageSize
     * @return
     */
    Map<String, Object> queryBusinessByQueryBuilder(String logType,String user,String startDate, String endDate, Integer pageNum, Integer pageSize) throws IOException;

}
