package com.artfess.cqxy.ledger.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.cqxy.ledger.model.MenuFieldTemp;
import com.artfess.cqxy.ledger.vo.MenuCustomizeParamVo;
import com.artfess.cqxy.ledger.vo.MenuCustomizeVo;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author baseli
 * @date 2022年6月5日20:13:46
 */
public interface MenuFieldTempManager extends BaseManager<MenuFieldTemp> {

    /**
     * 根据模板ID查询所有数据
     * @param menuCustomizeParamVo
     * @return
     */
    MenuCustomizeVo getDataById(MenuCustomizeParamVo menuCustomizeParamVo);

    /**
     * 根据模板ID查询所有数据(新的逻辑实现)
     * @param menuCustomizeParamVo
     * @return
     */
    MenuCustomizeVo getDataByIds(MenuCustomizeParamVo menuCustomizeParamVo);

    /**
     * 根据模板ID查询所有数据(新的逻辑实现)
     * @param menuCustomizeParamVo
     * @return
     */
    MenuCustomizeVo getDataByIdss(MenuCustomizeParamVo menuCustomizeParamVo);

    /**
     * 根据模板ID查询导出数据
     * @param menuCustomizeParamVo
     */
    void exportDataToExcel(MenuCustomizeParamVo menuCustomizeParamVo, HttpServletResponse response) throws IOException;

    /**
     * 根据表名获取列
     * @param tableNmae
     * @return
     */
    List<String> getColumnByTable(String tableNmae);

    /**
     * 判断列名是否存在
     * @param tableNmae
     * @param column
     * @return boolean,false:不存在，true：存在
     */
    public boolean haveColumn(String tableNmae, String column);
}
