package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 移交表(BizAcceptanceFinalTransfer)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-10 15:53:07
 */
@Data
@TableName("BIZ_ACCEPTANCE_FINAL_TRANSFER")
@ApiModel(value="竣工验收-移交对象-AcceptanceFinalTransfer", description="竣工验收-移交表")
public class AcceptanceFinalTransfer extends BizModel<AcceptanceFinalTransfer> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称（选择项目后自动填入）")
    private String projectName;

    @Excel(name = "移交单位")
    @TableField("FINAL_ACCOUNTS_OPINIONS_")
    @ApiModelProperty(value = "移交单位")
    private String finalAccountsOpinions;

    @Excel(name = "移交时间",format = "yyyy-MM-dd")
    @TableField("FINAL_ACCOUNTS_DATE_")
    @ApiModelProperty(value = "移交时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalAccountsDate;

    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人")
    private String handler;

    @Excel(name = "接收单位")
    @TableField("RECEIVING_UNIT_")
    @ApiModelProperty(value = "接收单位")
    private String receivingUnit;

    @Excel(name = "接收人")
    @TableField("RECEIVER_")
    @ApiModelProperty(value = "接收人")
    private String receiver;

    @Excel(name = "移交内容")
    @TableField("HANDOVER_CONTENT_")
    @ApiModelProperty(value = "移交内容")
    private String handoverContent;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;


    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "AcceptanceFinalTransfer{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", projectName='" + projectName + '\'' +
                ", finalAccountsOpinions='" + finalAccountsOpinions + '\'' +
                ", finalAccountsDate=" + finalAccountsDate +
                ", handler='" + handler + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

