package com.artfess.cqxy.bidManagement.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import cn.afterturn.easypoi.handler.inter.IExcelDataModel;
import cn.afterturn.easypoi.handler.inter.IExcelModel;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 招投标管理 - 招标管理表(BiddingManagement)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-08 15:32:29
 */
@Data
@TableName("BIZ_BIDDING_MANAGEMENT")
@ApiModel(value="招投标管理-招投标对象-BizBiddingManagement", description="招投标管理表")
public class BiddingManagement extends BizModel<BiddingManagement> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "招标名称")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "招标名称")
    private String documentNumber;

    @Excel(name = "招标方式")
    @TableField("BIDDING_CHARGE_TYPE_")
    @ApiModelProperty(value = "招标方式，（使用字典：1：公开招标，2：直接委托，3：走流程，4其他）")
    private String biddingChargeType;

    @Excel(name = "招标限价（元）")
    @TableField("BID_AMOUNT_EXAMINE_")
    @ApiModelProperty(value = "招标限价（元）")
    private String bidAmountExamine;

    //中标信息
    @Excel(name = "中标人")
    @TableField("BID_WINNER_")
    @ApiModelProperty(value = "中标人")
    private String bidWinner;

    @Excel(name = "中标人资质等级")
    @TableField("BID_WINNER_AGENT_PHONE_")
    @ApiModelProperty(value = "中标人资质等级")
    private String bidWinnerAgentPhone;

    @Excel(name = "中标总金额（单位：元）")
    @TableField("BID_AMOUNT_")
    @ApiModelProperty(value = "中标总金额（单位：元）")
    private String bidAmount;

    @Excel(name = "安全文明施工费（单位：元）")
    @TableField("ACTUAL_SETTLEMENT_AMOUNT_")
    @ApiModelProperty(value = "安全文明施工费（单位：元）")
    private String actualSettlementAmount;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @Excel(name = "招标代理机构")
    @TableField("BIDDING_AGENCY_")
    @ApiModelProperty(value = "招标代理机构")
    private String biddingAgency;

    @Excel(name = "招标范围")
    @TableField("RESPONSIBLE_UNIT_")
    @ApiModelProperty(value = "招标范围")
    private String responsibleUnit;

    @Excel(name = "招标企业数量")
    @TableField("RESPONSIBLE_PERSON_")
    @ApiModelProperty(value = "招标企业数量")
    private Integer responsiblePerson;

    @Excel(name = "投标保证金金额")
    @TableField("PROJECT_BUDGET_")
    @ApiModelProperty(value = "投标保证金金额（万元）")
    private String projectBudget;

    @Excel(name = "投标保证金支付方式")
    @TableField("IMPLEMENTATION_PERSONNEL_PHONE_")
    @ApiModelProperty(value = "投标保证金支付方式（使用字典，1：现金，2：保函）")
    private String implementationPersonnelPhone;

//    @Excel(name = "保函附件）")
    @TableField("IMPLEMENTATION_PERSONNEL_PHONE_URL_")
    @ApiModelProperty(value = "保函附件存储URL）")
    private String implementationPersonnelPhoneUrl;

    @Excel(name = "评标方法")
    @TableField("IMPLEMENTATION_PERSONNEL_NAME_")
    @ApiModelProperty(value = "评标方法（使用字典，1：经评审的最低中标法，2：综合评标法）")
    private String implementationPersonnelName;

    @Excel(name = "开标日期",format = "yyyy-MM-dd")
    @TableField("COMMENCEMENT_DATE_")
    @ApiModelProperty(value = "开标日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementDate;

    @Excel(name = "是否违法违规")
    @TableField("FUNDS_SOURCE_")
    @ApiModelProperty(value = "是否违法违规（使用字典：1：否，0：是")
    private String fundsSource;

//    @Excel(name = "违法违规附件")
    @TableField("FUNDS_SOURCE_URL_")
    @ApiModelProperty(value = "违法违规附件URL")
    private String fundsSourceUrl;

    @Excel(name = "有无投诉")
    @TableField("HAS_COMPLAINT_")
    @ApiModelProperty(value = "有无投诉，（0：有，1：无）")
    private String hasComplaint;

//    @Excel(name = "投诉文件")
    @TableField("HAS_COMPLAINT_URL_")
    @ApiModelProperty(value = "投诉文件url")
    private String hasComplaintUrl;

    @Excel(name = "投诉情况")
    @TableField("COMPLAINT_SITUATION_")
    @ApiModelProperty(value = "投诉情况")
    private String complaintSituation;

    @Excel(name = "项目概况")
    @TableField("ACTUAL_PAYMENT_METHOD_")
    @ApiModelProperty(value = "项目概况")
    private String actualPaymentMethod;

//    @Excel(name = "投资性质")
    @TableField("CONTRACT_PAYMENT_METHOD_")
    @ApiModelProperty(value = "投资性质(使用字典，1：国有，2：非国有)")
    private String contractPaymentMethod;

    @Excel(name = "项目经理")
    @TableField("BID_WINNER_AGENT_NAME_")
    @ApiModelProperty(value = "项目经理")
    private String bidWinnerAgentName;

//    @Excel(name = "签发日期")
    @TableField("COMPLETION_DATE_")
    @ApiModelProperty(value = "签发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate;

//    @Excel(name = "收款人及账号")
    @TableField("PAYEE_NAME_ACCOUNT_")
    @ApiModelProperty(value = "收款人及账号")
    private String payeeNameAccount;

    @Excel(name = "项目经理电话")
    @TableField("PAYEE_PHONE_")
    @ApiModelProperty(value = "项目经理电话")
    private String payeePhone;


    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BiddingManagement{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", biddingChargeType=" + biddingChargeType +
                ", documentNumber='" + documentNumber + '\'' +
                ", bidWinner='" + bidWinner + '\'' +
                ", bidAmount='" + bidAmount + '\'' +
                ", biddingAgency='" + biddingAgency + '\'' +
                ", projectBudget='" + projectBudget + '\'' +
                ", fundsSource=" + fundsSource +
                ", hasComplaint=" + hasComplaint +
                ", complaintSituation='" + complaintSituation + '\'' +
                ", bidWinnerAgentName='" + bidWinnerAgentName + '\'' +
                ", bidWinnerAgentPhone='" + bidWinnerAgentPhone + '\'' +
                ", bidAmountExamine='" + bidAmountExamine + '\'' +
                ", commencementDate=" + commencementDate +
                ", completionDate=" + completionDate +
                ", implementationPersonnelName='" + implementationPersonnelName + '\'' +
                ", implementationPersonnelPhone='" + implementationPersonnelPhone + '\'' +
                ", actualPaymentMethod='" + actualPaymentMethod + '\'' +
                ", contractPaymentMethod='" + contractPaymentMethod + '\'' +
                ", actualSettlementAmount='" + actualSettlementAmount + '\'' +
                ", responsibleUnit='" + responsibleUnit + '\'' +
                ", responsiblePerson='" + responsiblePerson + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

