package com.artfess.portal.config;

import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.actuate.trace.http.InMemoryHttpTraceRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**http://localhost:8001/plat/actuator/httptrace
 * @author wh
 * @Package com.sysplat.config
 * @date 2020/7/2 11:17
 * @Description:http请求追踪配置 底层方法使用了synchronized，并且默认只存储最近到100条，如果并发量大的话，性能会有所影响 考虑对方法重写
 * https://www.cnblogs.com/kebibuluan/p/12289101.html
 */
@Configuration
// @Profile("actuator-endpoints") /* if you want: register bean only if profile is set */
public class HttpTraceActuatorConfiguration {

    @Bean
    public HttpTraceRepository httpTraceRepository() {
        return new RemoteHttpTraceRepository();
    }

}