package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.OperationButtonEntity;
import com.artfess.form.persistence.manager.OperationButtonManager;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 业务列表模型  --- 功能操作按钮配置表 前端控制器
 * </p>
            *
            * @author wh
 * @since 2020-05-19
            */
@RestController
@RequestMapping("/components/button")
@Slf4j
@Api(tags="系统按钮")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class OperationButtonController extends BaseController<OperationButtonManager, OperationButtonEntity> {

    @Autowired
    private OperationButtonManager moduleButtonService;

    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "自定义系统按钮列表(分页条件查询)数据", httpMethod = "POST", notes = "自定义系统按钮列表(分页条件查询)数据")
    public @ResponseBody
    PageList<OperationButtonEntity> listJson(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<OperationButtonEntity> queryFilter) throws Exception {
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return moduleButtonService.query(queryFilter);
    }

    @PostMapping(value = "/queryModuleButtonById")
    @ApiOperation("根据id查询")
    @RequestMapping(value = "queryModuleButtonById", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public OperationButtonEntity queryModuleButtonById(@ApiParam("按钮ID") @RequestParam String id){
            OperationButtonEntity m= this.moduleButtonService.getById(id);
            return m;
    }

    @PostMapping(value = "/deleteModuleButton")
    @ApiOperation("根据id批量删按钮")
    @RequestMapping(value = "deleteModuleButton", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiImplicitParam(name = "ids", value = "主键ID，批量删除是用逗号隔开", required = true)
    public CommonResult<String> deleteModuleButton(String ids){

            if(StringUtils.isNotBlank(ids)){
                List<String> arrIds = Arrays.asList(ids.split(","));
                this.moduleButtonService.deleteModuleButton(arrIds);
            }else{
                return new CommonResult<String>(false,"ids不能为空！");
            }
            return new CommonResult<String>(true,"成功");
    }


    @PostMapping(value = "/insertModuleButton")
    @ApiOperation("添加按钮")
    @RequestMapping(value = "insertModuleButton", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public OperationButtonEntity insertModuleButton(@RequestBody OperationButtonEntity module){
        if(module.getSn()==null){
            module.setSn(this.moduleButtonService.queryNextSequence());
        }
        module.setFlag(1);
        module.setDelFlag(1);
        this.moduleButtonService.saveModuleButton(module);
        return module;

    }

    @PostMapping(value = "/updateModuleButton")
    @ApiOperation("修改按钮")
    @RequestMapping(value = "updateModuleButton", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public OperationButtonEntity updateModuleButton(@RequestBody OperationButtonEntity module){
            this.moduleButtonService.saveModuleButton(module);
            return module;

    }

}
