package com.artfess.cqxy.feasiblePlan.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.feasiblePlan.dao.PlanningUseLandDao;
import com.artfess.cqxy.feasiblePlan.manager.PlanningUseLandManager;
import com.artfess.cqxy.feasiblePlan.model.PlanningUseLand;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 规划许可-用地表(BizPlanningUseLand)表服务实现类
 * @author 黎沐华
 * @since 2022-02-15 10:40:00
 */
@Service
public class PlanningUseLandManagerImpl extends BaseManagerImpl<PlanningUseLandDao, PlanningUseLand> implements PlanningUseLandManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private SysDictionaryManager sdm;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(PlanningUseLand entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>():flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.four.getCode());
            ele.setGroup("PlanningUseLand");
            ele.setNode(ProjectStatusEnum.four.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.four.getCode()));
        // 同步开竣工时间
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        if(null != projectManagement){
            // 开公时间
            if(projectManagement.getCommencementTime() == null){
                projectManagement.setCommencementTime(entity.getCommencementTime());
            }
            //完工时间
            if(null == projectManagement.getCompletionTime()){
                projectManagement.setCompletionTime(entity.getCompletionTime());
            }
            pmm.updateById(projectManagement);
        }
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, PlanningUseLand entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.seven.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.seven.getName());
        globalRetrieval.setBizTableName(FunctionEnum.seven.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.seven.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.seven.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.seven.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.seven.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.seven.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setCertificateNumber(entity.getCode());
        globalRetrieval.setSearchTitle(entity.getName()+"_"+entity.getDocumentNumber()+"_"+entity.getConstructionProjectName()+"_"+
                entity.getParcelPurpose()+"_"+entity.getProposedLocation()+"_"+entity.getEstablishmentRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public PlanningUseLand getById(String id) {
        PlanningUseLand result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<PlanningUseLand> queryAllByPage(QueryFilter<PlanningUseLand> queryFilter) {
        BizUtils.handleFilter(queryFilter,"bpul" ,"pm");
        IPage<PlanningUseLand> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<PlanningUseLand> records = result.getRecords();
        for (PlanningUseLand ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId,"项目ID不能为空");
        List<DictModel> landRightAcquisitionMode = sdm.queryDictListItemsByCode("ydgl-qdtdsyqfs");
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<PlanningUseLand> data = ExcelImportUtil.importExcel(inputStream,PlanningUseLand.class,new ImportParams());
            for(PlanningUseLand ele:data){
                ele.setProjectId(projectId);
                ele.setLandRightAcquisitionMode(BizUtils.getDicCodeByValue(landRightAcquisitionMode, ele.getLandRightAcquisitionMode()));
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<PlanningUseLand> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "规划许可-用地规划-导出结果";
        // 获取字典
        List<DictModel> landMode = sdm.queryDictListItemsByCode("ydgl-qdtdsyqfs");

        // 获取数据
        BizUtils.handleFilter(queryFilter, "bpul", "pm");
        List<PlanningUseLand> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0,-1,false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // 翻译字典
        for(PlanningUseLand ele : data){
            ele.setLandRightAcquisitionMode(BizUtils.getDicValueByCode(landMode, ele.getLandRightAcquisitionMode()));
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, PlanningUseLand.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<PlanningUseLand> wrapper = new UpdateWrapper<PlanningUseLand>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }
}

