package com.artfess.cqxy.contract.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Item;
import com.artfess.cqxy.processManagermant.model.ProgressManageDefinite;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 合同明细表(BizContractItem)表服务接口
 *
 * @author 黎沐华
 * @since 2022-02-26 10:55:37
 */
public interface ItemManager extends BaseManager<Item> {

    PageList<Item> queryAllByPage(QueryFilter<Item> queryFilter);

    boolean deleteByIds(List<String> ids);

    /**
     * 导入Excel数据
     * @param file 文件
     * @param contractId 合同ID
     */
    void importExcelData(MultipartFile file, String contractId);

    /**
     * 读取Excel数据
     * @param file 文件
     */
    List<Item> readExcelData(MultipartFile file);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<Item> queryFilter, HttpServletResponse response) throws IOException;

}

