/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.contract.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.manager.FundPlanManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.contract.model.FundPlan;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5408\u540c\u7ba1\u7406-\u8d44\u91d1\u8ba1\u5212\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/contract/fundPlan/v1"})
public class FundPlanController
extends BaseController<FundPlanManager, FundPlan> {
    private static final Logger log = LoggerFactory.getLogger(FundPlanController.class);
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private ContractManager cm;

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult insert(@RequestBody FundPlan fundPlan) {
        Contract contract;
        Assert.notNull((Object)fundPlan.getProjectId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        boolean add = StringUtils.isEmpty((CharSequence)fundPlan.getId());
        if (StringUtils.isNotBlank((CharSequence)fundPlan.getContractId()) && null != (contract = (Contract)((Object)this.cm.getById((Serializable)((Object)fundPlan.getContractId()))))) {
            fundPlan.setContractName(contract.getName());
        }
        ((FundPlanManager)this.baseService).saveOrUpdate((Object)fundPlan);
        String msg = add ? "\u6dfb\u52a0" : "\u4fee\u6539\u6210\u529f\uff01";
        return new CommonResult(true, msg);
    }

    @PostMapping(value={"/importExcelData"})
    @ApiOperation(value="S-\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e")
    public CommonResult importExcelData(@ApiParam(value="\u4e0a\u4f20\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, String projectId, String contractId) {
        log.debug("\u6279\u91cf\u5bfc\u5165Excel\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{file, projectId, contractId});
        ((FundPlanManager)this.baseService).importExcelData(file, projectId, contractId);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981\uff0c\u67e5\u8be2\u6761\u4ef6\u8981\u5e26\u4e0a\u8868\u522b\u540d\uff1a\u4e3b\u8868 bra\u3001\u526f\u8868 pm\uff1b\u4f20\u5165pm.ID_\u5bfc\u51fa\u8be5\u9879\u76ee\u4e0b\u7684\u6570\u636e\uff0c\u5426\u5219\u5c06\u5bfc\u51fa\u6240\u6709\u6570\u636e")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        ((FundPlanManager)this.baseService).exportDatatoExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((FundPlanManager)this.baseService).deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u5408\u540c\u7ba1\u7406-\u8d44\u91d1\u8ba1\u5212-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<FundPlan> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        FundPlan result = ((FundPlanManager)this.baseService).getById(id);
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        log.debug("\u5408\u540c\u7ba1\u7406-\u8d44\u91d1\u8ba1\u5212-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u4f20\u5165 PROJECT_ID_ \u9879\u76eeID \u4ee5\u5207\u6362\u9879\u76ee\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014\u4e3b\u8868\u4e3abra\u3001\u526f\u8868\u4e3apm", httpMethod="POST")
    public CommonResult<PageList<FundPlan>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<FundPlan> queryFilter) {
        PageList<FundPlan> result = ((FundPlanManager)this.baseService).queryAllByPage(queryFilter);
        log.debug("\u5408\u540c\u7ba1\u7406-\u8d44\u91d1\u8ba1\u5212-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel2"})
    @ApiOperation(value="S-\u5bfc\u51fa\u672c\u6708\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981\uff0c\u67e5\u8be2\u6761\u4ef6\u8981\u5e26\u4e0a\u8868\u522b\u540d\uff1a\u4e3b\u8868 bra\u3001\u526f\u8868 pm\uff1b\u4f20\u5165pm.ID_\u5bfc\u51fa\u8be5\u9879\u76ee\u4e0b\u7684\u6570\u636e\uff0c\u5426\u5219\u5c06\u5bfc\u51fa\u6240\u6709\u6570\u636e")
    public CommonResult exportDataToExcel2(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u672c\u6708\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        ((FundPlanManager)this.baseService).exportDatatoExcel2(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

