/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.feasiblePlan.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.feasiblePlan.dao.PlanningUseLandDao;
import com.artfess.cqxy.feasiblePlan.manager.PlanningUseLandManager;
import com.artfess.cqxy.feasiblePlan.model.PlanningUseLand;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PlanningUseLandManagerImpl
extends BaseManagerImpl<PlanningUseLandDao, PlanningUseLand>
implements PlanningUseLandManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(PlanningUseLand entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.four.getCode());
            ele.setGroup("PlanningUseLand");
            ele.setNode(ProjectStatusEnum.four.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.four.getCode()));
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        if (null != projectManagement) {
            if (projectManagement.getCommencementTime() == null) {
                projectManagement.setCommencementTime(entity.getCommencementTime());
            }
            if (null == projectManagement.getCompletionTime()) {
                projectManagement.setCompletionTime(entity.getCompletionTime());
            }
            this.pmm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, PlanningUseLand entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.seven.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.seven.getName());
        globalRetrieval.setBizTableName(FunctionEnum.seven.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.seven.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.seven.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.seven.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.seven.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.seven.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setCertificateNumber(entity.getCode());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getDocumentNumber() + "_" + entity.getConstructionProjectName() + "_" + entity.getParcelPurpose() + "_" + entity.getProposedLocation() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public PlanningUseLand getById(String id) {
        PlanningUseLand result = ((PlanningUseLandDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<PlanningUseLand> queryAllByPage(QueryFilter<PlanningUseLand> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpul", "pm");
        IPage<PlanningUseLand> result = ((PlanningUseLandDao)this.baseMapper).queryAllByPage((IPage<PlanningUseLand>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PlanningUseLand>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (PlanningUseLand ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List landRightAcquisitionMode = this.sdm.queryDictListItemsByCode("ydgl-qdtdsyqfs");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, PlanningUseLand.class, (ImportParams)new ImportParams());
            for (PlanningUseLand ele : data) {
                ele.setProjectId(projectId);
                ele.setLandRightAcquisitionMode(BizUtils.getDicCodeByValue(landRightAcquisitionMode, ele.getLandRightAcquisitionMode()));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<PlanningUseLand> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u89c4\u5212\u8bb8\u53ef-\u7528\u5730\u89c4\u5212-\u5bfc\u51fa\u7ed3\u679c";
        List landMode = this.sdm.queryDictListItemsByCode("ydgl-qdtdsyqfs");
        BizUtils.handleFilter(queryFilter, "bpul", "pm");
        List data = ((PlanningUseLandDao)this.baseMapper).queryAllByPage((IPage<PlanningUseLand>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<PlanningUseLand>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (PlanningUseLand ele : data) {
            ele.setLandRightAcquisitionMode(BizUtils.getDicValueByCode((List<DictModel>)landMode, ele.getLandRightAcquisitionMode()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, PlanningUseLand.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

