package com.artfess.form.persistence.dao;

import com.artfess.form.model.FormDataTemplate;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 业务数据模板
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
public interface FormDataTemplateDao extends BaseMapper<FormDataTemplate> {
    /**
     * 根据表单key获取
     *
     * @param formKey
     * @return
     */
    List<FormDataTemplate> getByFormKey(String formKey);

    /**
     * 根据数据报表别名获取
     *
     * @param alias
     * @return
     */
    FormDataTemplate getByAlias(String alias);

    Integer getCountByAlias(@Param("alias") String alias);

    /**
     * 根据表单key删除
     *
     * @param formKey
     */
    void removeByFormKey(String formKey);

    /**
     * 获取所有业务数据模板的表单key
     *
     * @return
     */
    List<String> getAllFormKeys();

}
