package com.artfess.application.persistence.manager.impl;

import com.artfess.base.exception.SystemException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.dao.MsgTemplateDao;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;

/**
 * 对象功能:消息模版 Manager
 * @author zhaoxy
 * @company 广州宏天软件股份有限公司
 * @email zhxy@jee-soft.cn
 * @date 2018-06-06 14:20
 */
@Service("msgTemplateManager")
public class MsgTemplateManagerImpl extends BaseManagerImpl<MsgTemplateDao, MsgTemplate> implements MsgTemplateManager {
	@Resource
	MsgTemplateDao msgTemplateDao;

	@Override
	public MsgTemplate getByKey(String templateKey){
		return baseMapper.getByKey(templateKey);
	}

	@Override
	public MsgTemplate getDefault(String typeKey){
		return baseMapper.getDefault(typeKey);
	}

	@Override
	public void setDefault(String id) {
		MsgTemplate MsgTemplate = this.get(id);
		String typeKey = MsgTemplate.getTypeKey();
		baseMapper.setNotDefaultByType(typeKey);
		baseMapper.setDefault(id);
	}

	@Override
	public Boolean isExistByKeyAndTypeKey(String key, String typeKey) {
		MsgTemplate msgTemplate = this.get(key);
		MsgTemplate msgTemplate2 = this.get(typeKey);
		if (msgTemplate==msgTemplate2){
			return false;
		}
		return baseMapper.isExistByKeyAndTypeKey(key,typeKey);
	}

	@Override
	public MsgTemplate queryMsgTemplateByKeyAndTypeKey(String key, String typeKey) {
		return baseMapper.queryMsgTemplateByKeyAndTypeKey(key,typeKey);
	}

	@Override
	public void setNotDefault(String id) {
		baseMapper.setNotDefaultById(id);
	}

	@Override
	public PageList<MsgTemplate> queryByType(QueryFilter queryFilter) {
		this.copyQuerysInParams(queryFilter);
		handleQueryFilter(queryFilter);
		PageBean pageBean = queryFilter.getPageBean();
		if (BeanUtils.isEmpty(pageBean)) {
			pageBean = new PageBean(1, 50, true);
		}
		IPage<MsgTemplate> query = msgTemplateDao.queryByType(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
		return new PageList<MsgTemplate>(query);

	}



	@Override
	public MsgTemplate gettypeKey(String typeKey) {
		return baseMapper.gettypeKey(typeKey);
	}


	private void handleQueryFilter(QueryFilter queryFilter) throws SystemException {
		if (BeanUtils.isEmpty(queryFilter)) {
			throw new SystemException("QueryFilter通用查询对象不能为空.");
		}
	}
}
