package com.artfess.security.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.security.model.SysAuthorization;

import java.util.Map;

public interface SysAuthorizationManager extends BaseManager<SysAuthorization> {

    String createDesFile(String id) throws Exception;

    //根据上传的文件路径解覆盖原来的授权码，析授权码并返回
    Map<String, String> uploadSystemAuthCode(String path);

    //系统启动的时候默认生成一个临时授权文件，存储在磁盘上
    void systemStartCreateFile() throws Exception;

    //客户在系统的界面中输入公司组织的名称后， 通过下载申请授权文件的信息下载到本地
    String systemCreateFile() throws Exception;

    //根据单位名称查询
    SysAuthorization getByName(String deptName);
}
