package com.artfess.bpm.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.bpm.persistence.model.BpmTaskReminder;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：任务催办 处理接口
 * 构建组：x5-bpmx-platform
 * 作者:miaojf
 * 邮箱:miaojf@jee-soft.cn
 * 日期:2016-07-28 16:52:36
 * 版权：广州宏天软件有限公司
 * </pre>
 */
public interface BpmTaskReminderManager extends BaseManager<BpmTaskReminder>{
	void deleteByTaskId(String id);
	/**
	 * 获取需要触发的催办项
	 * @return
	 */
	List<BpmTaskReminder> getTriggerReminders();
	
	/**
	 * 执行催办任务
	 */
	void executeTaskReminderJob() throws Exception ;

	/**
	 * 根据实例ID修改催办任务
	 * @param instId
	 * @return
	 * @throws Exception
	 */
	CommonResult<String> modifyTaskReminder(String instId) throws Exception;

	void executeScript(BpmTaskReminder reminder, Map<String,Object> map) throws Exception;

	void forbiddenTaskReminder(String instId);

	void allowTaskReminder(String instId);
}
