package com.artfess.application.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消息配置实体对象
 *
 * @company artfess
 * @author wangping
 * @date 2021-06-18 17:49:50
 */
@ApiModel(description="消息配置实体对象")
@TableName("PORTAL_SYS_MSG_CONFIG")
public class MessageConfig extends AutoFillModel<MessageConfig> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name="id", notes="主键")
    @TableId("ID_")
    protected String id;

    @ApiModelProperty(name="name", notes="配置名称")
    @TableField("NAME_")
    protected String name;

    @ApiModelProperty(name="code", notes="配置编码")
    @TableField("CODE_")
    protected String code;

    @ApiModelProperty(name="tplKey", notes="模板业务键")
    @TableField("TPL_KEY_")
    protected String tplKey;

    @ApiModelProperty(name="notifyType", notes="消息提醒方式(voice: '语音', mail: '邮件', sms: '短信', inner: '站内消息')，多个用“,”号隔开")
    @TableField("NOTIFY_TYPE_")
    protected String notifyType;

    @ApiModelProperty(name="userConfigType", notes="接收人配置方式(1:动态，2：固定)")
    @TableField("USER_CONFIG_TYPE_")
    protected Short userConfigType;

    @ApiModelProperty(name="userStr", notes="接收人配置信息（动态配置：el表达式；固定方式：json格式字符串）")
    @TableField("USER_STR_")
    protected String userStr;

    @ApiModelProperty(name="userId", notes="用户id")
    @TableField("USER_ID_")
    protected String userId;

    @ApiModelProperty(name="orgId", notes="组织id")
    @TableField("ORG_ID_")
    protected String orgId;

    @ApiModelProperty(name="description", notes="描述")
    @TableField("DESCRIPTION_")
    protected String description;

    @ApiModelProperty(name="categoryName", notes="分类名")
    @TableField(exist = false)
    protected String categoryName;

    @ApiModelProperty(name="templateName", notes="模板名")
    @TableField(exist = false)
    protected String templateName;

    public String getCategoryName() {
        return categoryName;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }



//    @ApiModelProperty(name="tenantId", notes="租户ID")
//    @TableField("tenant_id_")
//    protected String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTplKey() {
        return tplKey;
    }

    public void setTplKey(String tplKey) {
        this.tplKey = tplKey;
    }

    public String getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public Short getUserConfigType() {
        return userConfigType;
    }

    public void setUserConfigType(Short userConfigType) {
        this.userConfigType = userConfigType;
    }

    public String getUserStr() {
        return userStr;
    }

    public void setUserStr(String userStr) {
        this.userStr = userStr;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

//    public String getTenantId() {
//        return tenantId;
//    }
//
//    public void setTenantId(String tenantId) {
//        this.tenantId = tenantId;
//    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "MessageConfig{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", tplKey='" + tplKey + '\'' +
                ", notifyType='" + notifyType + '\'' +
                ", userConfigType=" + userConfigType +
                ", userStr='" + userStr + '\'' +
                ", userId='" + userId + '\'' +
                ", orgId='" + orgId + '\'' +
                ", description='" + description + '\'' +
//                ", tenantId='" + tenantId + '\'' +
                '}';
    }
}
