package com.artfess.sysConfig.persistence.model;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 日志配置
* <pre> 
* 描述：日志配置 实体对象
* 构建组：artfess
* 作者:baseli
* 日期:2021年6月9日15:46:28
* </pre>
*/
@ApiModel(description = "日志配置") 
@TableName("portal_sys_logs_settings")
public class SysLogsSettings extends BaseModel<SysLogsSettings>{

   private static final long serialVersionUID = 1L;
   
   @ApiModelProperty(value="编码")
   @TableId("id_")
   protected String id;

   @ApiModelProperty(value="模块")
   @TableField("module_type_")
   protected String moduleType; 
   
   @ApiModelProperty(value="状态")
   @TableField("status_")
   protected String status; 
   
   @ApiModelProperty(value="保留天数")
   @TableField("save_days_")
   protected Integer saveDays; 
   
   @ApiModelProperty(value="描述")
   @TableField("remark_")
   protected String remark;

    @ApiModelProperty(value="日志类型，1：登录日志，2：异常日志，3：操作日志")
    @TableField("LOG_TYPE_")
    protected Integer logType;


    @ApiModelProperty(value="能否删除,1:不能删除，其他都可以删除")
    @TableField("ENABLE_DEL_")
    protected Integer enableDel;


    public void setId(String id) {
       this.id = id;
   }
   
   /**
    * 返回 编码
    * @return
    */
   public String getId() {
       return this.id;
   }
   
   public void setModuleType(String moduleType) {
       this.moduleType = moduleType;
   }
   
   /**
    * 返回 模块
    * @return
    */
   public String getModuleType() {
       return this.moduleType;
   }
   
   public void setStatus(String status) {
       this.status = status;
   }
   
   /**
    * 返回 状态
    * @return
    */
   public String getStatus() {
       return this.status;
   }
   
   public void setSaveDays(Integer saveDays) {
       this.saveDays = saveDays;
   }
   
   /**
    * 返回 保留天数
    * @return
    */
   public Integer getSaveDays() {
       return this.saveDays;
   }
   
   public void setRemark(String remark) {
       this.remark = remark;
   }

    public Integer getLogType() {
        return logType;
    }

    public void setLogType(Integer logType) {
        this.logType = logType;
    }

    public Integer getEnableDel() {
        return enableDel;
    }

    public void setEnableDel(Integer enableDel) {
        this.enableDel = enableDel;
    }

    /**
    * 返回 描述
    * @return
    */
   public String getRemark() {
       return this.remark;
   }
   /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id) 
       .append("moduleType", this.moduleType) 
       .append("status", this.status) 
       .append("saveDays", this.saveDays)
               .append("logType", this.logType)
               .append("remark", this.remark)
       .toString();
   }

}