package com.artfess.sysConfig.enums;

import com.artfess.base.exception.ApplicationException;

import java.util.HashMap;
import java.util.Map;

public enum BaseInfoStatus {
    DRAFT(-1, "草稿"), DISABLED(0, "禁用"), ENABLED(1, "启用");

    private final int id;
    private final String displayName;

    private BaseInfoStatus(int id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static BaseInfoStatus fromId(int id) {
        switch (id) {
            case 0:
                return DISABLED;
            case 1:
                return ENABLED;
            case -1:
                return DRAFT;
        }
        throw new ApplicationException(String.format("无效的状态“%s”。", new Object[]{Integer.valueOf(id)}));
    }

    public static Map<Integer, String> getData() {
        Map<Integer, String> result = new HashMap<Integer, String>(2);
        for (BaseInfoStatus item : values()) {
            if (item != DRAFT) {
                result.put(Integer.valueOf(item.getId()), item.getDisplayName());
            }
        }
        return result;
    }

    public static boolean isDraft(int id) {
        return DRAFT.getId() == id;
    }
}