/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.attachment.AttachmentServiceFactory;
import com.artfess.base.exception.NotFoundException;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.attachmentService.FtpAttachmentServiceImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.service.FilePreview;
import com.artfess.file.service.FilePreviewFactory;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.util.FileUtils;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/onlinePreviewController/v1"})
@Api(tags={"\u9644\u4ef6\u5728\u7ebf\u9884\u89c8"})
@ApiGroup(group={"group_system"})
public class OnlinePreviewController {
    @Resource
    FilePreviewFactory previewFactory;
    @Resource
    FileManager fileManager;
    @Resource
    FileUtils fileUtils;
    @Value(value="${file.file.dir}")
    String fileDir;

    @RequestMapping(value={"onlinePreview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u5728\u7ebf\u9884\u89c8", httpMethod="GET", notes="\u9644\u4ef6\u5728\u7ebf\u9884\u89c8")
    public JsonNode onlinePreview(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        DefaultFile fileMode = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        if (fileMode != null) {
            boolean ref;
            AttachmentService attachmentService;
            AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            String saveType = AppFileUtil.getSaveType(fileMode.getProp6());
            if (StringUtil.isEmpty((String)saveType)) {
                saveType = AppFileUtil.getFileSaveTypeByConfig(BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getBizCode() : "");
            }
            if ((attachmentService = attachmentHandlerFactory.getCurrentServices(saveType)) instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(fileMode.getStoreType())) {
                attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER);
            }
            if (ref = attachmentService.chekckFile((Attachment)fileMode, BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getProp6() : "")) {
                FilePreview filePreview = this.previewFactory.get(fileMode);
                String Result = filePreview.filePreviewHandle(fileMode, map);
                map.put("result", Result);
                map.remove("project");
            } else {
                map.put("result", "error");
            }
        }
        JsonNode object = JsonUtil.toJsonNode(map);
        return object;
    }

    @RequestMapping(value={"getFileByPathAndId_{fileId}_{ext}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u548c\u7c7b\u578b\u627e\u5230\u5904\u7406\u540e\u7684\u9644\u4ef6", httpMethod="GET", notes="\u6839\u636eID\u548c\u7c7b\u578b\u627e\u5230\u9644\u4ef6")
    public void getFileByPathAndId(HttpServletResponse response, @PathVariable(name="fileId") String fileId, @PathVariable(name="ext") String ext) throws IOException {
        String fullPath = this.fileDir + fileId + "." + ext;
        String type = "text/html;charset=" + OnlinePreviewController.getCharset(fullPath);
        if ("pdf".equals(ext)) {
            type = "application/pdf";
        }
        response.setContentType(type);
        byte[] bytes = FileUtil.readByte((String)fullPath);
        if (bytes != null && bytes.length > 0) {
            response.getOutputStream().write(bytes);
        }
    }

    @RequestMapping(value={"getFileById_{fileId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6ID\u627e\u5230\u4e0a\u4f20\u8fc7\u7684\u6587\u4ef6", httpMethod="GET", notes="\u6839\u636e\u6587\u4ef6ID\u627e\u5230\u4e0a\u4f20\u8fc7\u7684\u6587\u4ef6")
    public void getFileById(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="fileId") String fileId) throws Exception {
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        }
        if (BeanUtils.isEmpty((Object)((Object)file))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a: %s \u7684\u6587\u4ef6", fileId));
        }
        String fileName = file.getFileName() + "." + file.getExtensionName();
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = new MimetypesFileTypeMap().getContentType(new File(file.getFilePath()));
        response.setContentType(type);
        this.fileManager.downloadFile(fileId, (OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCharset(String pathName) {
        File file = new File(pathName);
        if (!file.exists()) {
            return "";
        }
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        BufferedInputStream bis = null;
        try {
            boolean checked = false;
            bis = new BufferedInputStream(new FileInputStream(file));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                String string = charset;
                return string;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                while ((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        return charset;
    }
}

