package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.WebUtil;
import com.mzt.logapi.service.IParseFunction;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @program: edp
 * @Date: 2021/3/10 16:43
 * @Author: baseli
 * @Description: 自定义IP获取函数
 */
@Component
public class EsLogIpFunction implements IParseFunction {
    @Override
    public String functionName() {
        //函数调用的名称
        return "GetIP";
    }

    @Override
    public String apply(String value) {
        //可以将以json对象传入
        HttpServletRequest request = HttpUtil.getRequest();
        String ip = "";
        if(null != request){
            ip = WebUtil.getIpAddr(request);
        }
        return "IP["+ip+"]";
    }
}
