/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activemq.producer;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.base.context.BaseContext;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.jms.Notice;
import javax.annotation.Resource;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Topic;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;

@Primary
@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class DefaultJmsProducer
implements JmsProducer {
    private static final Log logger = LogFactory.getLog(DefaultJmsProducer.class);
    @Resource
    private Queue queue;
    @Resource
    private Topic topic;
    @Resource
    JmsMessagingTemplate jmsMessagingTemplate;
    @Resource
    BaseContext baseContext;
    QueueSession session = null;

    public void sendToQueue(Object object) {
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)this.queue, (Object)notice);
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)this.queue, (Object)jmsMessage);
        } else {
            this.jmsMessagingTemplate.convertAndSend((Object)this.queue, object);
        }
        logger.debug((Object)"[JMS]: Send to queue.");
    }

    public void sendToTopic(Object object) {
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)this.topic, (Object)notice);
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)this.topic, (Object)jmsMessage);
        } else {
            this.jmsMessagingTemplate.convertAndSend((Object)this.topic, object);
        }
        logger.debug((Object)"[JMS]: send to topic.");
    }

    public void sendToQueue(Object object, String queueName) {
        Queue bnsQueue = this.getQueue(queueName);
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)bnsQueue, (Object)notice);
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)bnsQueue, (Object)jmsMessage);
        } else {
            this.jmsMessagingTemplate.convertAndSend((Object)bnsQueue, object);
        }
        logger.debug((Object)("[JMS]: Send to queue\uff1a" + queueName));
    }

    public void sendToTopic(Object object, String topicName) {
        Topic bnsTopic = this.getTopic(topicName);
        if (object instanceof Notice) {
            Notice notice = (Notice)object;
            notice.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)bnsTopic, (Object)notice);
        } else if (object instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)object;
            jmsMessage.setTenantId(this.baseContext.getCurrentTenantId());
            this.jmsMessagingTemplate.convertAndSend((Object)bnsTopic, (Object)jmsMessage);
        } else {
            this.jmsMessagingTemplate.convertAndSend((Object)bnsTopic, object);
        }
        logger.debug((Object)("[JMS]: send to topic\uff1a" + topicName));
    }

    private Queue getQueue(String queueName) {
        ActiveMQQueue bnsQueue = new ActiveMQQueue(queueName);
        return bnsQueue;
    }

    private Topic getTopic(String topicName) {
        ActiveMQTopic bnsTopic = new ActiveMQTopic(topicName);
        return bnsTopic;
    }
}

