/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.ElectronicSealManager;
import com.artfess.uc.model.ElectronicSeal;
import com.artfess.uc.model.User;
import com.artfess.uc.params.seal.ImportSignatureObject;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/electronicSeal/v1"})
@Api(tags={"\u7535\u5b50\u5370\u7ae0"})
@ApiGroup(group={"group_uc"})
public class ElectronicSealController
extends BaseController<ElectronicSealManager, ElectronicSeal> {
    @Resource
    ElectronicSealManager electronicSealManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="uc_electronic_seal\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6uc_electronic_seal\u5217\u8868")
    public PageList<ElectronicSeal> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.electronicSealManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="uc_electronic_seal\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="uc_electronic_seal\u6570\u636e\u8be6\u60c5")
    public ElectronicSeal get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (ElectronicSeal)this.electronicSealManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> save(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        String msg = "\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f";
        String currentUserId = electronicSeal.getUserId();
        ElectronicSeal seal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)currentUserId)).eq((Object)"IS_USE_", (Object)0)));
        if (BeanUtils.isEmpty((Object)((Object)seal))) {
            electronicSeal.setIsUse(0);
            electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            this.electronicSealManager.create((Model)electronicSeal);
        } else {
            this.electronicSealManager.setIsUse(seal.getId());
            ElectronicSeal electronicSealNew = new ElectronicSeal();
            electronicSealNew.setUserId(electronicSeal.getUserId());
            electronicSealNew.setIsUse(0);
            electronicSealNew.setFileId(electronicSeal.getFileId());
            if (StringUtil.isEmpty((String)electronicSeal.getPassword())) {
                ElectronicSeal electronicSealOld = (ElectronicSeal)this.electronicSealManager.get((Serializable)((Object)electronicSeal.getId()));
                electronicSealNew.setPassword(electronicSealOld.getPassword());
            } else {
                electronicSealNew.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            }
            this.electronicSealManager.create((Model)electronicSealNew);
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"userSave"})
    @ApiOperation(value="front\u7528\u6237\u81ea\u5df1\u6dfb\u52a0\u7535\u5b50\u7b7e\u7ae0", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> userSave(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        String msg = "\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f";
        User user = ContextUtil.getCurrentUser();
        if (!user.getPassword().equals(this.passwordEncoder.encode((CharSequence)electronicSeal.getOldPassWord()))) {
            return new CommonResult(false, "\u60a8\u8f93\u5165\u7684\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)electronicSeal.getId())) {
            electronicSeal.setIsUse(0);
            electronicSeal.setUserId(user.getId());
            electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            this.electronicSealManager.create((Model)electronicSeal);
        } else {
            if (StringUtil.isEmpty((String)electronicSeal.getOldPassWord())) {
                return new CommonResult(false, "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            }
            ElectronicSeal seal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)user.getId())).eq((Object)"IS_USE_", (Object)0)));
            if (BeanUtils.isNotEmpty((Object)((Object)seal))) {
                this.electronicSealManager.setIsUse(electronicSeal.getId());
                ElectronicSeal electronicSealNew = new ElectronicSeal();
                electronicSealNew.setUserId(user.getId());
                electronicSealNew.setIsUse(0);
                electronicSealNew.setFileId(electronicSeal.getFileId());
                if (StringUtil.isNotEmpty((String)electronicSeal.getPassword())) {
                    electronicSealNew.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
                } else {
                    electronicSealNew.setPassword(seal.getPassword());
                }
                this.electronicSealManager.create((Model)electronicSealNew);
            } else {
                return new CommonResult(false, "\u672a\u83b7\u53d6\u5230\u6b63\u5728\u4f7f\u7528\u7684\u7b7e\u7ae0\u3002");
            }
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"mobileUpdate"})
    @ApiOperation(value="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0", httpMethod="POST", notes="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0")
    public CommonResult<String> mobileUpdate(@RequestBody ElectronicSeal electronicSeal) throws Exception {
        if (StringUtil.isEmpty((String)electronicSeal.getPassword())) {
            return new CommonResult(false, "\u8bf7\u8f93\u5165\u7b7e\u7ae0\u5bc6\u7801");
        }
        User user = ContextUtil.getCurrentUser();
        ElectronicSeal electronicSealOld = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)user.getId())));
        if (BeanUtils.isNotEmpty((Object)((Object)electronicSealOld))) {
            if (!user.getPassword().equals(this.passwordEncoder.encode((CharSequence)electronicSeal.getOldPassWord()))) {
                return new CommonResult(false, "\u60a8\u8f93\u5165\u7684\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u4e0d\u53ef\u66f4\u65b0\u7b7e\u7ae0");
            }
        } else {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u7b7e\u7ae0\uff0c\u8bf7\u5728\u5e94\u7528\u7aef\u6dfb\u52a0\u7b7e\u7ae0\u540e\uff0c\u65b9\u53ef\u4f7f\u7528");
        }
        electronicSealOld.setIsUse(1);
        this.electronicSealManager.update((Model)electronicSealOld);
        electronicSeal.setUserId(user.getId());
        electronicSeal.setIsUse(0);
        electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
        this.electronicSealManager.create((Model)electronicSeal);
        return new CommonResult("\u66f4\u65b0\u7b7e\u7ae0\u6210\u529f");
    }

    @RequestMapping(value={"getElectronicSeal"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id")
    public CommonResult<String> getUser(@ApiParam(name="password", value="\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801") @RequestParam(required=true) Optional<String> password, @ApiParam(name="secretFree", value="\u662f\u5426\u514d\u5bc6") @RequestParam(required=true) Optional<Boolean> secretFree) throws Exception {
        boolean isSecretFree = secretFree.orElse(false);
        if (!isSecretFree && StringUtil.isEmpty((String)password.get())) {
            return new CommonResult(false, "\u8bf7\u8f93\u5165\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801");
        }
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal)) || StringUtil.isEmpty((String)electronicSeal.getFileId())) {
            return new CommonResult(false, "\u60a8\u8fd8\u672a\u8bbe\u7f6e\u7b7e\u7ae0\uff0c\u8bf7\u5728\u4e2a\u4eba\u4fe1\u606f\u4e2d\u8bbe\u7f6e\u60a8\u7684\u7b7e\u7ae0");
        }
        if (!isSecretFree && !electronicSeal.getPassword().equals(this.encryptSealPassword(password.get()))) {
            return new CommonResult(false, "\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)electronicSeal.getFileId());
    }

    @GetMapping(value={"/getSealByUserId/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7535\u5b50\u7b7e\u7ae0")
    public ElectronicSeal getSealByUserId(@PathVariable(value="userId") String userId) {
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)userId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return null;
        }
        electronicSeal.setPassword("");
        return electronicSeal;
    }

    @GetMapping(value={"/getSealByCurrentUserId"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7535\u5b50\u7b7e\u7ae0")
    public ElectronicSeal getCurrentUserSeal() {
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return null;
        }
        electronicSeal.setPassword("");
        return electronicSeal;
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664uc_electronic_seal\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664uc_electronic_seal\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.electronicSealManager.removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveSignatureBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", httpMethod="POST", notes="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e")
    public CommonResult<String> saveSignatureBatch(@ApiParam(name="signatureData", value="\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", required=true) @RequestBody ImportSignatureObject signatureData) throws Exception {
        return ((ElectronicSealManager)this.baseService).importSignature(signatureData);
    }

    private String encryptSealPassword(String blankPswd) throws Exception {
        return EncryptUtil.encrypt((String)blankPswd);
    }
}

