import TabsComponent from '@/components/common/TabsComponent.vue'
export default [
  //工作台
  {
    path: 'workBench',
    name: 'workBench',
    component: () => import('@/views/SysIndex.vue'),
  },
  {
    path:'myMeeting',
    path:'myMeeting',
    component: () => import('@/views/main/MyMeeting.vue'),
  },
  {
    path:'historyMeeting',
    path:'historyMeeting',
    component: () => import('@/views/main/HistoricalConference.vue'),
  },

  {
    path:'roomManagement',
    path:'roomManagement',
    component: () => import('@/views/main/VenueManagement.vue'),
  },


  // 会场管理
  {
    path: 'venueManagement',
    name: 'venueManagement',
    component: () => import('@/views/main/VenueManagement.vue'),
  },
  // 历史会议
  {
    path: 'historicalConference',
    name: 'historicalConference',
    component: () => import('@/views/main/HistoricalConference.vue'),
  },
  // 系统管理
  {
    path: 'myOrganization',
    name: 'myOrganization',
    component: () => import('@/views/main/systemManagement/MyOrganization.vue'),
  },
  // 系统调度
  {
    path: 'systemScheduling',
    name: 'systemScheduling',
    component: () => import('@/views/main/systemManagement/SystemScheduling.vue'),
  },
  // 在线用户
  {
    path: 'onlineUsers',
    name: 'onlineUsers',
    component: () => import('@/views/main/systemManagement/OnlineUsers.vue'),
  },
  // 系统授权
  {
    path: 'systemAuthorization',
    name: 'systemAuthorization',
    component: () => import('@/views/main/systemManagement/SystemAuthorization.vue'),
  },
  // 菜单管理
  {
    path: 'menuManagerRouterFvue',
    name: 'menuManagerRouterFvue',
    component: TabsComponent,
  },
  // 组织权限
  {
    path: 'userManger',
    name: 'userManger',
    component: TabsComponent,
  },
  // 群组管理
  {
    path: 'groupManagement',
    name: 'groupManagement',
    component: () => import('@/views/main/organizationPermission/GroupManagement.vue'),
  },
  // 角色管理
  {
    path: 'orgManger',
    name: 'orgManger',
    component: () => import('@/views/main/organizationPermission/OrgManger.vue'),
  },
  // 用户管理
  {
    path: 'dataPermission',
    name: 'dataPermission',
    component: () => import('@/views/main/organizationPermission/DataPermission.vue'),
  },
  // 系统缓存
  {
    path: 'SystemCache',
    name: 'SystemCache',
    component: TabsComponent
  },
  // 组织管理
  {
    path: 'organizationManagement',
    name: 'organizationManagement',
    component: TabsComponent
  },
  // 设备管理
  {
    path: 'deviceManagement',
    name: 'deviceManagement',
    component: () => import('@/views/main/systemSafety/DeviceManagement.vue'),
  },
  // 密码策略
  {
    path: 'passwordPolicy',
    name: 'passwordPolicy',
    component: () => import('@/views/main/systemSafety/PasswordPolicy.vue'),
  },
   // 账号解锁
   {
    path: 'accountUnlock',
    name: 'accountUnlock',
    component: () => import('@/views/main/systemSafety/AccountUnlock.vue'),
  },
  //系统调度 --- > 计划列表
  {
    path: 'schedulerTriggerList/:jobName',
    name: 'schedulerTriggerList',
    component:  () => import('@/views/main/systemManagement/SchedulerTriggerList.vue'),
    meta: {
      keepAlive: true
    }
  },
  //系统调用 --- > 日志
  {
    path: 'executeJobList/:jobName',
    name: 'executeJobList',
    component:  () => import('@/views/main/systemManagement/ExecuteJobList.vue'),
    meta: {
      keepAlive: true //页面跳转重新渲染 默认不渲染
    }
  },
]
