/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.service.impl;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.attachment.AttachmentServiceFactory;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.attachmentService.FtpAttachmentServiceImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.service.FilePreview;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.util.FileUtils;
import com.artfess.file.util.OfficeToPdf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OfficeFilePreviewImpl
implements FilePreview {
    private static final Logger log = LoggerFactory.getLogger(OfficeFilePreviewImpl.class);
    @Autowired
    FileUtils fileUtils;
    @Value(value="${file.file.dir}")
    String fileDir;
    @Resource
    AttachmentServiceFactory attachmentServiceFactory;
    @Autowired
    private OfficeToPdf officeToPdf;

    @Override
    public String filePreviewHandle(DefaultFile fileMode, Map map) {
        String fileName = fileMode.getId() + "." + fileMode.getExtensionName();
        String suffix = fileMode.getExtensionName();
        String filePath = this.fileDir + fileMode.getId() + "." + fileMode.getExtensionName();
        String checkfilePath = filePath.substring(0, filePath.lastIndexOf(".") + 1) + "pdf";
        boolean falg = this.checkFile(checkfilePath, map);
        if (!falg) {
            String outFilePath;
            if (!new File(filePath).exists()) {
                try {
                    AttachmentService attachmentService;
                    File dirFile = new File(this.fileDir);
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    }
                    String separator = File.separator;
                    if (!filePath.contains(File.separator)) {
                        separator = File.separator.equals("/") ? "\\\\" : "/";
                    }
                    String saveType = null;
                    if (!StringUtil.isEmpty((String)fileMode.getStoreType())) {
                        fileMode.setProp6(fileMode.getStoreType());
                        saveType = fileMode.getStoreType();
                    }
                    AppFileUtil.createPath(filePath.substring(0, filePath.lastIndexOf(separator)), fileName);
                    if (StringUtil.isEmpty((String)saveType) && StringUtil.isEmpty((String)(saveType = AppFileUtil.getSaveType(fileMode.getProp6())))) {
                        saveType = AppFileUtil.getFileSaveTypeByConfig(BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getBizCode() : "");
                    }
                    if ((attachmentService = this.attachmentServiceFactory.getCurrentServices(saveType)) instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(fileMode.getStoreType())) {
                        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
                        attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER);
                    }
                    attachmentService.download((Attachment)fileMode, (OutputStream)new FileOutputStream(filePath), BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getProp6() : "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.hasText((String)(outFilePath = filePath.substring(0, filePath.lastIndexOf(".") + 1) + "pdf"))) {
                long systemTime = System.currentTimeMillis();
                log.info("------------------------openOffice \u6587\u4ef6:{} \u8f6c\u6362\u5f00\u59cb------------------------", (Object)fileMode.getFileName());
                this.officeToPdf.openOfficeToPDF(filePath, outFilePath, false);
                long overTime = System.currentTimeMillis() - systemTime;
                log.info("------------------------openOffice \u6587\u4ef6\u8f6c\u6362\u7ed3\u675f\uff0c\u8017\u65f6:{}------------------------", (Object)overTime);
                File f = new File(filePath);
                if (f.exists()) {
                    map.put("fileSize", f.length());
                    f.delete();
                }
            }
        }
        map.put("pdfUrl", "/file/onlinePreviewController/v1/getFileByPathAndId_" + fileMode.getId() + "_" + "pdf");
        return "pdf";
    }

    private boolean checkFile(String path, Map map) {
        File file = new File(path);
        if (file.exists()) {
            map.put("fileSize", file.length());
        }
        return file.exists();
    }
}

