/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public class WordUtil {
    public static void createWord(HttpServletResponse response, Map dataMap, String templateName, String filePath, String fileName) {
        try {
            Configuration configuration = new Configuration();
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(WordUtil.class, "/");
            Template template = configuration.getTemplate("FTL_Template/" + templateName);
            File outFile = new File(filePath);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            template.process((Object)dataMap, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File generateAndZipWordFiles(List<?> dataList, String filePath, String docName, String outputZipPath) {
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(WordUtil.class, "/");
            configuration.setNumberFormat("0");
            File tempDir = new File("tempWordFiles");
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            for (int i = 0; i < dataList.size(); ++i) {
                Object data = dataList.get(i);
                String outputFilePath = tempDir.getAbsolutePath() + File.separator + docName + i + ".docx";
                File outputFile = new File(outputFilePath);
                Template template = configuration.getTemplate(filePath);
                try (FileOutputStream fos = new FileOutputStream(outputFile);
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));){
                    template.process(data, (Writer)writer);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try (FileOutputStream fos = new FileOutputStream(outputZipPath);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (File file : tempDir.listFiles()) {
                    try (FileInputStream fis = new FileInputStream(file);){
                        int length;
                        ZipEntry zipEntry = new ZipEntry(file.getName());
                        zipOut.putNextEntry(zipEntry);
                        byte[] bytes = new byte[1024];
                        while ((length = fis.read(bytes)) >= 0) {
                            zipOut.write(bytes, 0, length);
                        }
                    }
                }
            }
            WordUtil.deleteTempDir(tempDir);
            return new File(outputZipPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void deleteTempDir(File tempDir) {
        File[] files;
        if (tempDir.isDirectory() && (files = tempDir.listFiles()) != null) {
            for (File file : files) {
                WordUtil.deleteTempDir(file);
            }
        }
        tempDir.delete();
    }
}

