/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public class ZipFileUtils {
    public static ResponseEntity<Resource> downLoadFile(byte[] zipData, final String fileName) {
        ByteArrayResource resource = new ByteArrayResource(zipData){

            public String getFilename() {
                return fileName;
            }
        };
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            String encodedFilename = URLEncoder.encode(resource.getFilename(), "UTF-8").replaceAll("\\+", "%20");
            headers.add("Content-Disposition", "attachment; filename=\"" + encodedFilename + "\"");
            headers.setContentLength((long)zipData.length);
            headers.setCacheControl("no-cache, no-store, must-revalidate");
            headers.setPragma("no-cache");
            headers.setExpires(0L);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)resource);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return ResponseEntity.notFound().build();
        }
    }
}

