/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.utils;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

public class RoadMarkerProcessor {
    private static final int DEFAULT_FOR_NULL_OR_INVALID = Integer.MAX_VALUE;
    private static final int MAX_MARKER_VALUE = Integer.MAX_VALUE;
    private static final int SUB_MARKER_LENGTH = 3;

    public static int safeProcessMarker(String marker) {
        return Optional.ofNullable(marker).filter(m -> !m.isEmpty()).map(m -> {
            try {
                String[] parts = m.split("\\+");
                if (parts.length != 2) {
                    return Integer.MAX_VALUE;
                }
                String beforePlus = parts[0].replaceAll("[^0-9]", "");
                String afterPlus = parts[1].replaceAll("[^0-9]", "");
                afterPlus = RoadMarkerProcessor.processSubMarker(afterPlus);
                return Integer.parseInt(beforePlus + afterPlus);
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }).orElse(Integer.MAX_VALUE);
    }

    private static String processSubMarker(String subMarker) {
        if (subMarker.isEmpty()) {
            return "000";
        }
        String truncated = subMarker.length() > 3 ? subMarker.substring(0, 3) : subMarker;
        return String.format("%03d", Integer.parseInt(truncated));
    }

    public static <T> Comparator<T> createSafeMarkerComparator(Function<T, String> keyExtractor) {
        return Comparator.comparingInt(obj -> RoadMarkerProcessor.safeProcessMarker((String)keyExtractor.apply(obj)));
    }

    public static <T> Comparator<T> createSafeMarkerComparator(Function<T, String> keyExtractor, boolean nullsLast) {
        Comparator<Object> comparator = Comparator.comparingInt(obj -> RoadMarkerProcessor.safeProcessMarker((String)keyExtractor.apply(obj)));
        return nullsLast ? Comparator.nullsLast(comparator) : Comparator.nullsFirst(comparator);
    }
}

