/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.rescue.base.manager.BizBaseCarManager;
import com.artfess.rescue.base.model.BizBaseCar;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBaseCar/v1/"})
@Api(tags={"\u5de1\u68c0\u6551\u63f4\u8f66\u8f86\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizBaseCarController
extends BaseController<BizBaseCarManager, BizBaseCar> {
    @Resource
    RescueOrgManager orgManager;

    @RequestMapping(value={"isVerSuccessfulCarNumber"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bf9\u8f66\u724c\u53f7\u8fdb\u884c\u53bb\u91cd\u9a8c\u8bc1", httpMethod="POST", notes="\u5bf9\u8f66\u724c\u53f7\u8fdb\u884c\u53bb\u91cd\u9a8c\u8bc1")
    public CommonResult<String> isRepeatCarNumber(@RequestParam(value="id", required=false) String id, @RequestParam(value="carNumber") String carNumber) {
        boolean res;
        return new CommonResult(res, (res = ((BizBaseCarManager)this.baseService).isVerSuccessfulCarNumber(id, carNumber)) ? "" : "\u5df2\u5b58\u5728\u8be5\u8f66\u724c\u53f7\u7684\u4fe1\u606f");
    }

    @GetMapping(value={"/getCar"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public CommonResult<List<BizBaseCar>> getCar(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestParam(value="roadId") String roadId, @RequestParam(value="type") List<Integer> type) {
        return CommonResult.success(((BizBaseCarManager)this.baseService).getCar(roadId, type), (String)"");
    }

    @GetMapping(value={"/list/{teamId}"})
    @ApiOperation(value="\u6839\u636e\u961f\u4f0did\u67e5\u8be2\u8f66\u8f86\u4fe1\u606f")
    public CommonResult<List<BizBaseCar>> getList(@PathVariable(value="teamId") String teamId) {
        return CommonResult.success(((BizBaseCarManager)this.baseService).getCarList(teamId), (String)"");
    }

    @PostMapping(value={"/findByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public PageList<BizBaseCar> findByPage(@RequestBody QueryFilter<BizBaseCar> queryFilter) {
        return ((BizBaseCarManager)this.baseService).findByPage(queryFilter);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizBaseCarManager)this.baseService).deleteByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizBaseCar> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizBaseCar> queryFilter) {
        List roadList = this.orgManager.roadTree().stream().map(OrgInfoVO::getRoadList).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList roadIds = new ArrayList();
        if (roadList.isEmpty()) {
            return new PageList();
        }
        for (List roads : roadList) {
            List ids = roads.stream().map(BizBaseRoad::getId).filter(Objects::nonNull).collect(Collectors.toList());
            roadIds.addAll(ids);
        }
        queryFilter.addFilter("c.ROAD_ID_", roadIds, QueryOP.IN);
        return ((BizBaseCarManager)this.baseService).query(queryFilter);
    }
}

