/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.utils;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class UserControlUtils {
    @Resource
    UCFeignService feignService;
    @Resource
    BaseContext baseContext;

    public void addDeptPermission(QueryFilter<?> queryFilter) {
        String deptId = this.baseContext.getCurrentDeptId();
        List childOrg = this.feignService.getChildOrg(deptId);
        ArrayList<String> collect = new ArrayList<String>();
        for (ObjectNode jsonNodes : childOrg) {
            String id = jsonNodes.get("id").asText();
            collect.add(id);
        }
        collect.add(deptId);
        String orgIds = collect.stream().collect(Collectors.joining(","));
        queryFilter.addFilter("CREATE_COMPANY_ID_", (Object)String.join((CharSequence)"','", orgIds), QueryOP.IN, FieldRelation.AND);
    }

    public void addOrgPermission(QueryFilter<?> queryFilter, String orgName) {
        String orgId = this.baseContext.getCurrentOrgId();
        List childOrg = this.feignService.getChildOrg(orgId);
        ArrayList<String> collect = new ArrayList<String>();
        for (ObjectNode jsonNodes : childOrg) {
            String id = jsonNodes.get("id").asText();
            collect.add(id);
        }
        collect.add(orgId);
        String orgIds = collect.stream().collect(Collectors.joining(","));
        queryFilter.addFilter(orgName, (Object)String.join((CharSequence)"','", orgIds), QueryOP.IN, FieldRelation.AND);
    }

    public List<String> getOrgIds() {
        String currentOrgId = this.baseContext.getCurrentOrgId();
        List childOrg = this.feignService.getChildOrg(currentOrgId);
        ArrayList<String> collect = new ArrayList<String>();
        for (ObjectNode jsonNodes : childOrg) {
            String id = jsonNodes.get("id").asText();
            collect.add(id);
        }
        collect.add(currentOrgId);
        return collect;
    }

    public List<String> getOrgIds(String currentOrgId) {
        List childOrg = this.feignService.getChildOrg(currentOrgId);
        ArrayList<String> collect = new ArrayList<String>();
        for (ObjectNode jsonNodes : childOrg) {
            String id = jsonNodes.get("id").asText();
            collect.add(id);
        }
        collect.add(currentOrgId);
        return collect;
    }

    public String getOrgGrade() {
        ObjectNode orgObj;
        ArrayList<String> gradeList = new ArrayList<String>();
        gradeList.add("1");
        gradeList.add("2");
        gradeList.add("3");
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = this.baseContext.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            String grade = orgObj.get("grade").asText();
            if (orgKind.equals("ogn") && gradeList.contains(grade)) {
                return orgObj.get("id").asText();
            }
            return UserControlUtils.getParentOrgGrade(orgObj.get("parentId").asText(), "id");
        }
        return "";
    }

    public static String getParentOrgGrade(String parentId, String attrName) {
        try {
            ArrayList<String> gradeList = new ArrayList<String>();
            gradeList.add("1");
            gradeList.add("2");
            gradeList.add("3");
            UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ObjectNode parentOrgObj = service.getOrgByIdOrCode(parentId);
            if (BeanUtils.isNotEmpty((Object)parentOrgObj)) {
                String orgKind = parentOrgObj.get("orgKind").asText();
                String grade = parentOrgObj.get("grade").asText();
                if (orgKind.equals("ogn") && gradeList.contains(grade)) {
                    return parentOrgObj.get(attrName).asText();
                }
                String parentOrgParentId = parentOrgObj.get("parentId").asText();
                return UserControlUtils.getParentOrgGrade(parentOrgParentId, attrName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void addPermissionByCreateOrgId(QueryFilter<?> queryFilter) {
        String currentOrgId = this.baseContext.getCurrentOrgId();
        List childOrg = this.feignService.getChildOrg(currentOrgId);
        ArrayList<String> collect = new ArrayList<String>();
        for (ObjectNode jsonNodes : childOrg) {
            String id = jsonNodes.get("id").asText();
            collect.add(id);
        }
        collect.add(currentOrgId);
        String orgIds = collect.stream().collect(Collectors.joining(","));
        queryFilter.addFilter("CREATE_ORG_ID_", (Object)String.join((CharSequence)"','", orgIds), QueryOP.IN, FieldRelation.AND);
    }

    public void addPermissionByCreateDeptId(QueryFilter<?> queryFilter) {
        String deptId = this.baseContext.getCurrentDeptId();
        queryFilter.addFilter("CREATE_COMPANY_ID_", (Object)deptId, QueryOP.EQUAL, FieldRelation.AND);
    }
}

