/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.event.dao.BizEventHandleDao;
import com.artfess.rescue.event.dao.BizEventInfoDao;
import com.artfess.rescue.event.dto.EventInfoDto;
import com.artfess.rescue.event.manager.BizEventDispatchManager;
import com.artfess.rescue.event.manager.BizEventHandleManager;
import com.artfess.rescue.event.model.BizEventDispatch;
import com.artfess.rescue.event.model.BizEventHandle;
import com.artfess.rescue.event.vo.HandInfoVO;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizEventHandleManagerImpl
extends BaseManagerImpl<BizEventHandleDao, BizEventHandle>
implements BizEventHandleManager {
    @Resource
    BizRescueFileCommonManager fileCommonManager;
    @Resource
    FileManager fileManager;
    @Resource
    BizEventInfoDao eventInfoDao;
    @Resource
    BizEventDispatchManager dispatchManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean accept(EventInfoDto dto) {
        int update;
        Assert.notNull((Object)((Object)dto.getHandle()), (String)"\u5904\u7f6e\u73af\u8282\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(dto.getDispatches(), (String)"\u6d3e\u9063\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = dto.getId();
        JSONObject team = ContextUtil.getCurrentTeam();
        String teamId = "";
        String teamName = "";
        String userId = "";
        if (team != null) {
            teamId = team.getString("teamId");
            teamName = team.getString("teamName");
            userId = team.getString("userId");
        }
        if ((update = this.eventInfoDao.updateByStatus(id, "2", userId)) == 0) {
            throw new ApplicationException("\u4e8b\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        List<BizEventDispatch> dispatches = dto.getDispatches();
        dispatches.forEach(e -> {
            e.setEventId(id);
            e.setDispatchTime(LocalDateTime.now());
        });
        boolean dispatchSave = this.dispatchManager.saveBatch(dispatches);
        if (!dispatchSave) {
            throw new ApplicationException("\u5904\u7f6e\u4eba\u5458\u4fdd\u5b58\u5931\u8d25");
        }
        BizEventHandle handle = dto.getHandle();
        handle.setEventId(id);
        handle.setEventNode("3");
        handle.setHandleInfo(ContextUtil.getCurrentUserName() + "\u5df2\u63a5\u6536\u4efb\u52a1");
        handle.setHandleTime(LocalDateTime.now());
        handle.setHandleUserId(ContextUtil.getCurrentUserId());
        handle.setHandleUserName(ContextUtil.getCurrentUserName());
        if (team != null) {
            handle.setHandleTeamId(teamId);
            handle.setHandleTeamName(teamName);
        }
        return this.save((Object)handle);
    }

    @Override
    public int countNode(String eventId, String nodeName) {
        LambdaQueryWrapper handleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)handleWrapper.eq(BizEventHandle::getEventId, (Object)eventId)).eq(BeanUtils.isNotEmpty((Object)nodeName), BizEventHandle::getEventNode, (Object)nodeName)).eq(BizDelModel::getIsDele, (Object)"0");
        return super.count((Wrapper)handleWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizEventHandle entity) {
        int update;
        boolean save;
        JSONObject team;
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            entity.setHandleUserId(user.getUserId());
            entity.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            entity.setHandleTeamId(team.getString("teamId"));
            entity.setHandleTeamName(team.getString("teamName"));
        }
        if (!(save = this.save((Object)entity))) {
            throw new ApplicationException("\u5904\u7f6e\u73af\u8282\u64cd\u4f5c\u5931\u8d25");
        }
        this.saveAttachments(entity);
        if (entity.getEventNode().equals("8") ? (update = this.eventInfoDao.updateByStatus(entity.getEventId(), "3", null)) == 0 : entity.getEventNode().equals("9") && (update = this.eventInfoDao.updateByStatus(entity.getEventId(), "4", null)) == 0) {
            throw new ApplicationException("\u4e8b\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean savePcInfo(BizEventHandle entity) {
        int update;
        boolean save;
        JSONObject team;
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            entity.setHandleUserId(user.getUserId());
            entity.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            entity.setHandleTeamId(team.getString("teamId"));
            entity.setHandleTeamName(team.getString("teamName"));
        }
        if (!(save = this.save((Object)entity))) {
            throw new ApplicationException("\u5904\u7f6e\u73af\u8282\u64cd\u4f5c\u5931\u8d25");
        }
        this.saveAttachments(entity);
        List<String> statusList = Arrays.asList("3", "4", "5", "6", "7");
        if (statusList.contains(entity.getEventNode()) ? (update = this.eventInfoDao.updateByStatus(entity.getEventId(), "2", null)) == 0 : (entity.getEventNode().equals("8") ? (update = this.eventInfoDao.updateByStatus(entity.getEventId(), "3", null)) == 0 : entity.getEventNode().equals("9") && (update = this.eventInfoDao.updateByStatus(entity.getEventId(), "4", null)) == 0)) {
            throw new ApplicationException("\u4e8b\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    public boolean saveEndInfo(BizEventHandle entity) {
        boolean save;
        JSONObject team;
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            entity.setHandleUserId(user.getUserId());
            entity.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            entity.setHandleTeamId(team.getString("teamId"));
            entity.setHandleTeamName(team.getString("teamName"));
        }
        if (!(save = this.save((Object)entity))) {
            throw new ApplicationException("\u5904\u7f6e\u73af\u8282\u64cd\u4f5c\u5931\u8d25");
        }
        this.saveAttachments(entity);
        return true;
    }

    private void saveAttachments(BizEventHandle entity) {
        List<BizRescueFileCommon> files = entity.getFiles();
        if (CollectionUtils.isNotEmpty(files)) {
            List fileIds = files.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        }
    }

    @Override
    @Transactional
    public boolean updateInfo(BizEventHandle entity) {
        this.rule(entity.getEventId(), entity.getEventNode());
        boolean update = this.updateById((Object)entity);
        if (!update) {
            return false;
        }
        this.saveAttachments(entity);
        return true;
    }

    @Override
    public List<HandInfoVO> getHands(String eventId) {
        List<HandInfoVO> list = ((BizEventHandleDao)this.baseMapper).findHandInfo(eventId);
        if (list == null) {
            return new ArrayList<HandInfoVO>();
        }
        List<String> fileCommonIds = list.stream().map(HandInfoVO::getId).collect(Collectors.toList());
        if (!fileCommonIds.isEmpty()) {
            Map<String, List<BizRescueFileCommon>> map = this.fileCommonManager.getFilePreviewLikeCommonIds(fileCommonIds).stream().collect(Collectors.groupingBy(BizRescueFileCommon::getCommonId));
            list.forEach(file -> file.setFiles((List)map.get(file.getId())));
        }
        return list;
    }

    @Override
    public List<HandInfoVO> getHandInfo(String id) {
        org.springframework.util.Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        List<HandInfoVO> list = ((BizEventHandleDao)this.baseMapper).findHandInfo(id);
        if (list == null) {
            return new ArrayList<HandInfoVO>();
        }
        List<String> fileCommonIds = list.stream().map(HandInfoVO::getId).collect(Collectors.toList());
        if (!fileCommonIds.isEmpty()) {
            Map<String, List<BizRescueFileCommon>> map = this.fileCommonManager.getFilePreviewLikeCommonIds(fileCommonIds).stream().collect(Collectors.groupingBy(BizRescueFileCommon::getCommonId));
            list.forEach(file -> file.setFiles((List)map.get(file.getId())));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> batchFinish(List<String> ids) {
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u65e0\u6cd5\u5b8c\u7ed3\uff0c\u672a\u9009\u4e2d\u4e8b\u4ef6\uff01", (Object[])new Object[0]);
        for (String id : ids) {
            BizEventHandle eventHandle = new BizEventHandle();
            eventHandle.setEventId(id);
            eventHandle.setEventNode("9");
            eventHandle.setHandleTime(LocalDateTime.now());
            this.saveInfo(eventHandle);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01");
    }

    void rule(String eventId, String node) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizDelModel::getIsDele, (Object)"0")).eq(BizEventHandle::getEventId, (Object)eventId)).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
        BizEventHandle handle = (BizEventHandle)((Object)this.getOne((Wrapper)wrapper));
        if (Integer.parseInt(handle.getEventNode()) > Integer.parseInt(node)) {
            throw new IllegalStateException("\u5f53\u524d\u5904\u7f6e\u73af\u8282\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u5904\u7406\u73af\u8282");
        }
    }
}

