/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.job;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.rescue.patrol.manager.BizInspectionPlanDetailsManager;
import com.artfess.rescue.patrol.manager.BizInspectionPlanManager;
import com.artfess.rescue.patrol.manager.BizInspectionTaskDetailsManager;
import com.artfess.rescue.patrol.manager.BizInspectionTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionPlan;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.artfess.rescue.patrol.model.BizInspectionTaskDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InspectionPlanJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(InspectionPlanJob.class);
    @Autowired
    private BizInspectionPlanManager inspectionPlanManager;
    @Autowired
    private BizInspectionTaskManager bizInspectionTaskManager;
    @Autowired
    private BizInspectionPlanDetailsManager planDetailsManager;
    @Autowired
    private BizInspectionTaskDetailsManager taskDetailsManager;

    public void executeJob(JobExecutionContext context) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String id = jobDataMap.getString("id");
        String logId = (String)jobDataMap.get((Object)"logId");
        String planId = jobDataMap.getString("planId");
        log.info("\u5b9a\u65f6\u8ba1\u5212\u6d4b\u8bd5\u6b63\u5e38com.artfess.rescue.patrol.job.InspectionPlanJob\uff0ctaskConfId:{}\uff0cid:{}\uff0clogId:{}", new Object[]{planId, id, logId});
        if (StringUtil.isEmpty((String)planId)) {
            log.error("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\u5b9a\u65f6\u5668\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de1\u68c0\u8ba1\u5212ID\u4e3a\u7a7a\uff01", (Object)((Object)((Object)this)).getClass().getName());
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de1\u68c0\u8ba1\u5212ID\u4e3a\u7a7a");
        }
        BizInspectionPlan inspectionPlan = this.inspectionPlanManager.findById(planId);
        if (null == inspectionPlan) {
            log.error("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\u5b9a\u65f6\u5668\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de1\u68c0\u8ba1\u5212\u4e0d\u5b58\u5728\uff01", (Object)((Object)((Object)this)).getClass().getName());
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5de1\u68c0\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        QueryWrapper planDetailsWrapper = new QueryWrapper();
        planDetailsWrapper.eq((Object)"PLAN_ID_", (Object)planId);
        List list = this.planDetailsManager.list((Wrapper)planDetailsWrapper);
        BizInspectionTask inspectionTask = new BizInspectionTask();
        inspectionTask.setPlanId(inspectionPlan.getId());
        inspectionTask.setPlanType(inspectionPlan.getPlanType());
        inspectionTask.setWorkclass(inspectionPlan.getWorkclass());
        inspectionTask.setInspectType(inspectionPlan.getInspectType());
        inspectionTask.setRoadId(inspectionPlan.getRoadId());
        inspectionTask.setRoadCode(inspectionPlan.getRoadCode());
        inspectionTask.setRoadName(inspectionPlan.getRoadName());
        inspectionTask.setStartPatrolId(inspectionPlan.getStartPatrolId());
        inspectionTask.setStartPatrolName(inspectionPlan.getStartPatrolName());
        inspectionTask.setEndPatrolId(inspectionPlan.getEndPatrolId());
        inspectionTask.setEndPatrolName(inspectionPlan.getEndPatrolName());
        inspectionTask.setTeamId(inspectionPlan.getTeamId());
        inspectionTask.setTeamName(inspectionPlan.getTeamName());
        LocalDate startDate = LocalDate.now();
        LocalDate endDate = inspectionPlan.getPlanDays() != null ? startDate.plusDays(inspectionPlan.getPlanDays().intValue()) : startDate;
        inspectionTask.setTaskDate(startDate);
        inspectionTask.setTaskEndDate(endDate);
        this.bizInspectionTaskManager.saveInfo(inspectionTask);
        ArrayList taskDetails = new ArrayList();
        String taskId = inspectionTask.getId();
        if (!list.isEmpty()) {
            list.forEach(detail -> {
                BizInspectionTaskDetails taskDetail = new BizInspectionTaskDetails();
                taskDetail.setPatrolId(detail.getPatrolId());
                taskDetail.setPatrolBatch(detail.getPatrolBatch());
                taskDetail.setTaskId(taskId);
                taskDetail.setCategory(detail.getCategory());
                taskDetail.setType(detail.getType());
                taskDetail.setPointLevel(detail.getPointLevel());
                taskDetail.setInspectionCycle(detail.getInspectionCycle());
                taskDetail.setContent(detail.getContent());
                taskDetail.setPeg(detail.getPeg());
                taskDetail.setPegAdd(detail.getPegAdd());
                taskDetail.setPegVal(detail.getPegVal());
                taskDetail.setDirection(detail.getDirection());
                taskDetail.setDirectionValue(detail.getDirectionValue());
                taskDetail.setLng(detail.getLng());
                taskDetail.setLat(detail.getLat());
                taskDetails.add(taskDetail);
            });
            this.taskDetailsManager.saveBatch(taskDetails);
        }
    }
}

