/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.rescue.patrol.manager.BizVideoInspectionManager;
import com.artfess.rescue.patrol.model.BizVideoInspection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bizVideoInspection/v1/"})
@Api(tags={"\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55"})
@ApiGroup(group={"group_biz_rescue"})
public class BizVideoInspectionController
extends BaseController<BizVideoInspectionManager, BizVideoInspection> {
    @PostMapping(value={"/batch/save"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55")
    public CommonResult<String> batchSave(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody List<BizVideoInspection> videoInspections) {
        return ((BizVideoInspectionManager)this.baseService).batchSave(videoInspections);
    }

    @GetMapping(value={"/downModel"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u7248")
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/videoInspection.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55")
    public CommonResult<List<BizVideoInspection>> importVideoInspection(@ApiParam(name="file", value="excel\u6a21\u677f\u6587\u4ef6", required=true) @RequestParam MultipartFile file) {
        return ((BizVideoInspectionManager)this.baseService).importVideoInspection(file);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55")
    public void exportVideoInspection(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizVideoInspection> queryFilter, HttpServletResponse response) {
        ((BizVideoInspectionManager)this.baseService).exportVideoInspection(queryFilter, response);
    }
}

