/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.context;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Component;

@Component
public class UserContextUtil {
    public boolean isAdmin(String userId) {
        CommonResult result;
        JsonNode userJson;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(userJson = (JsonNode)(result = service.getUserById(userId)).getValue()))) {
            return userJson.get("account").asText().contains("admin");
        }
        return false;
    }

    public String getCurrentOrgIdByUserId(String userId) {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("id").asText();
            }
            if (orgKind.equals("dept")) {
                return UserContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "id");
            }
        }
        return "";
    }

    public String getCurrentOrgNameByUserId(String userId) {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("name").asText();
            }
            if (orgKind.equals("dept")) {
                return UserContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "name");
            }
        }
        return "";
    }

    public String getCurrentDeptIdByUserId(String userId) {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("id").asText();
        }
        return "";
    }

    public String getCurrentDeptNameByUserId(String userId) {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("name").asText();
        }
        return "";
    }

    public static String getParentOrgAttr(String parentId, String attrName) {
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        ObjectNode parentOrgObj = service.getOrgByIdOrCode(parentId);
        if (BeanUtils.isNotEmpty((Object)parentOrgObj)) {
            String orgKind = parentOrgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return parentOrgObj.get(attrName).asText();
            }
            if (orgKind.equals("dept")) {
                String parentOrgParentId = parentOrgObj.get("parentId").asText();
                return UserContextUtil.getParentOrgAttr(parentOrgParentId, attrName);
            }
        }
        return "";
    }
}

