/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.rescue.base.manager.BizCarTaskLogManager;
import com.artfess.rescue.base.model.BizCarTaskLog;
import com.artfess.rescue.patrol.dao.BizInspectionResultDao;
import com.artfess.rescue.patrol.dto.ReplaceCarVO;
import com.artfess.rescue.patrol.manager.BizInspectionResultDetailManager;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.artfess.rescue.patrol.model.BizInspectionResultDetail;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BizInspectionResultManagerImpl
extends BaseManagerImpl<BizInspectionResultDao, BizInspectionResult>
implements BizInspectionResultManager {
    @Resource
    BizInspectionResultDetailManager inspectionResultDetailManager;
    @Resource
    private UCFeignService ucFeignService;
    @Resource
    BizCarTaskLogManager carTaskLogManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizInspectionResult t) {
        boolean save = this.save((Object)t);
        if (save) {
            this.processDetail(t);
        }
        return save;
    }

    private void processDetail(BizInspectionResult t) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizInspectionResultDetail::getResultId, (Object)t.getId());
        this.inspectionResultDetailManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(t.getResultDetails())) {
            return;
        }
        this.inspectionResultDetailManager.saveBatch(t.getResultDetails());
    }

    @Override
    public BizInspectionResult findById(String id) {
        BizInspectionResult result = ((BizInspectionResultDao)this.baseMapper).findById(id);
        if (null == result) {
            return new BizInspectionResult();
        }
        List<BizInspectionResultDetail> list = this.inspectionResultDetailManager.findByResultId(id);
        if (list != null && !list.isEmpty()) {
            result.setResultDetails(list);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizInspectionResult t) {
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processDetail(t);
        }
        return save;
    }

    @Override
    public PageList<BizInspectionResult> findByPage(QueryFilter<BizInspectionResult> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizInspectionResult> result = ((BizInspectionResultDao)this.baseMapper).findByPage((IPage<BizInspectionResult>)this.convert2IPage(pageBean), (QueryWrapper<BizInspectionResult>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List orgIds = result.getRecords().stream().map(BizInspectionResult::getTeamId).collect(Collectors.toList());
        ArrayNode orgArrayNode = this.ucFeignService.getOrgsByIds(String.join((CharSequence)",", orgIds));
        HashMap map = Maps.newHashMap();
        if (BeanUtils.isNotEmpty((Object)orgArrayNode)) {
            for (JsonNode orgNode : orgArrayNode) {
                String name = JsonUtil.getString((JsonNode)orgNode, (String)"name");
                String id = JsonUtil.getString((JsonNode)orgNode, (String)"id");
                map.put(id, name);
            }
        }
        result.getRecords().forEach(detail -> {
            if (CollectionUtils.isEmpty((Map)map)) {
                return;
            }
            if (null != map.get(detail.getTeamId())) {
                detail.setTeamName((String)map.get(detail.getTeamId()));
            }
        });
        return new PageList(result);
    }

    @Override
    public PageList<BizInspectionResult> queryByPage(QueryFilter<BizInspectionResult> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizInspectionResult> result = ((BizInspectionResultDao)this.baseMapper).page((IPage<BizInspectionResult>)this.convert2IPage(pageBean), (QueryWrapper<BizInspectionResult>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean replaceCar(ReplaceCarVO carVO) {
        BizCarTaskLog bthModel = carVO.getBthModel();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BizCarTaskLog::getId, (Object)bthModel.getId())).set(BizCarTaskLog::getTaskId, (Object)bthModel.getTaskId())).set(BizCarTaskLog::getIsUse, (Object)0)).set(BizCarTaskLog::getEndMileage, (Object)bthModel.getEndMileage());
        this.carTaskLogManager.update((Wrapper)updateWrapper);
        BizCarTaskLog thModel = carVO.getThModel();
        thModel.setIsUse(1);
        boolean save = this.carTaskLogManager.save((Object)thModel);
        if (!save) {
            return false;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BizInspectionResult::getTaskId, (Object)thModel.getTaskId());
        wrapper.set(BizInspectionResult::getCarCode, (Object)thModel.getCarCode());
        wrapper.set(BizInspectionResult::getCarAppearance, (Object)thModel.getCarAppearance());
        wrapper.set(BizInspectionResult::getCarEngine, (Object)thModel.getCarEngine());
        wrapper.set(BizInspectionResult::getCarFfe, (Object)thModel.getCarFfe());
        wrapper.set(BizInspectionResult::getCarLight, (Object)thModel.getCarLight());
        wrapper.set(BizInspectionResult::getCarOp, (Object)thModel.getCarOp());
        return this.update((Wrapper)wrapper);
    }
}

