/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.rescue.common.util.ExcelUtil;
import com.artfess.rescue.common.util.PointUtil;
import com.artfess.rescue.event.dao.BizEventInfoDao;
import com.artfess.rescue.event.dao.BizRescueCostDao;
import com.artfess.rescue.event.dto.FullEventDto;
import com.artfess.rescue.event.enums.EventTypeEnum;
import com.artfess.rescue.event.enums.EventTypeLwEnum;
import com.artfess.rescue.event.manager.BizCompensationDetailsManager;
import com.artfess.rescue.event.manager.BizCompensationInfoManager;
import com.artfess.rescue.event.manager.BizEventHandleManager;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.manager.BizTrafficCongestionManager;
import com.artfess.rescue.event.manager.BizTrafficControlManager;
import com.artfess.rescue.event.model.BizCompensationDetails;
import com.artfess.rescue.event.model.BizCompensationInfo;
import com.artfess.rescue.event.model.BizEventHandle;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.model.BizRescueCost;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.model.BizTrafficCongestion;
import com.artfess.rescue.event.model.BizTrafficControl;
import com.artfess.rescue.event.vo.CountEventByTimeVO;
import com.artfess.rescue.event.vo.CountEventByTypeVO;
import com.artfess.rescue.event.vo.EventInfoVO;
import com.artfess.rescue.event.vo.EventLedgerVO;
import com.artfess.rescue.event.vo.HandInfoVO;
import com.artfess.rescue.event.vo.TrafficControlIlboVO;
import com.artfess.rescue.event.vo.TrafficControlMonthReportVO;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizEventInfoManagerImpl
extends BaseManagerImpl<BizEventInfoDao, BizEventInfo>
implements BizEventInfoManager {
    private static final Logger log = LoggerFactory.getLogger(BizEventInfoManagerImpl.class);
    @Resource
    BizCompensationInfoManager compensationInfoManager;
    @Resource
    BizRescueInfoManager rescueInfoManager;
    @Resource
    BizCompensationDetailsManager detailsManager;
    @Resource
    BizEventHandleManager handleManager;
    @Resource
    SysIdentityManager sysIdentityManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    SysDictionaryManager sdm;
    @Resource
    BaseContext baseContext;
    @Resource
    BizTrafficCongestionManager congestionManager;
    @Resource
    BizTrafficControlManager controlManager;
    @Resource
    private PointUtil pointUtil;
    @Resource
    BizRescueCostDao costDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizEventInfo entity) {
        String eventNo = this.sysIdentityManager.nextId("sjdjh");
        entity.setEventNo(eventNo);
        entity.setEventStatus(-1);
        String lwEventType = entity.getLwEventType();
        if (StringUtils.isEmpty((CharSequence)lwEventType)) {
            throw new ApplicationException("\u8bf7\u9009\u62e9\u4e8b\u4ef6\u5bf9\u5e94\u7684\u4e8b\u4ef6\u7c7b\u578b");
        }
        String result = EventTypeEnum.getResultByValue(entity.getLwEventType());
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            entity.setEventType(result);
        }
        this.setLngAndLat(entity);
        boolean save = this.save((Object)entity);
        if (!save) {
            return false;
        }
        this.setTrafficInfo(entity);
        LocalDateTime now = LocalDateTime.now();
        BizEventHandle handle = this.setUser(entity.getId(), "1", now);
        this.handleManager.save((Object)handle);
        if (lwEventType.equals("38")) {
            BizEventHandle finishHandle = this.setUser(entity.getId(), "9", now.plusSeconds(1L));
            this.handleManager.saveInfo(finishHandle);
        }
        try {
            BizCompensationInfo compensationInfo = new BizCompensationInfo();
            BeanUtils.copyNotNullProperties((Object)((Object)compensationInfo), (Object)((Object)entity));
            compensationInfo.setEventId(entity.getId());
            compensationInfo.setId(null);
            String compensationNo = this.sysIdentityManager.nextId("pcdjh");
            compensationInfo.setCompensationNo(compensationNo);
            this.compensationInfoManager.save((Object)compensationInfo);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        String rescueId = entity.getRescueId();
        if (StringUtils.isNotEmpty((CharSequence)rescueId)) {
            this.setRescueInfo(rescueId, entity.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizEventInfo entity) {
        BizEventInfo info;
        String result;
        this.setTrafficInfo(entity);
        if (StringUtils.isNotEmpty((CharSequence)entity.getLwEventType()) && StringUtils.isNotEmpty((CharSequence)(result = EventTypeEnum.getResultByValue(entity.getLwEventType())))) {
            entity.setEventType(result);
        }
        this.setLngAndLat(entity);
        if (entity.getLwEventType().equals("38") && !(info = (BizEventInfo)this.get((Serializable)((Object)entity.getId()))).getLwEventType().equals("38")) {
            BizEventHandle finishHandle = this.setUser(entity.getId(), "9", LocalDateTime.now());
            this.handleManager.saveInfo(finishHandle);
        }
        return this.updateById((Object)entity);
    }

    void setRescueInfo(String rescueId, String eventId) {
        LambdaUpdateWrapper rescueWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)rescueWrapper.eq(BizRescueInfo::getId, (Object)rescueId)).set(BizRescueInfo::getEventId, (Object)eventId);
        this.rescueInfoManager.update((Wrapper)rescueWrapper);
    }

    void setTrafficInfo(BizEventInfo entity) {
        List<BizTrafficCongestion> congestionList;
        String id = entity.getId();
        Map dictMap = this.sysDictionaryDetailManager.getTextByMap("gzcs");
        List<BizTrafficControl> controlList = entity.getTrafficControls();
        if (controlList != null && controlList.size() > 0) {
            for (BizTrafficControl control : controlList) {
                DictionaryDetailVo vo;
                control.setEventId(id);
                if (BeanUtils.isEmpty((Object)control.getStatus()) || control.getStatus() == 0) {
                    control.setStatus(1);
                }
                if (!StringUtils.isEmpty((CharSequence)control.getMeasureContent()) || (vo = (DictionaryDetailVo)dictMap.get(control.getMeasureType())) == null) continue;
                control.setMeasureContent(vo.getName());
            }
            this.controlManager.saveOrUpdateBatch(controlList);
        }
        if ((congestionList = entity.getTrafficCongestions()) != null && congestionList.size() > 0) {
            for (BizTrafficCongestion control : congestionList) {
                control.setEventId(id);
            }
            this.congestionManager.saveOrUpdateBatch(congestionList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean appoint(FullEventDto entity) {
        String rescueId;
        List<BizRescueInfo> rescueInfo;
        List<BizTrafficCongestion> congestionList;
        if (entity.getEventNo() == null) {
            String eventNo = this.sysIdentityManager.nextId("sjdjh");
            entity.setEventNo(eventNo);
        }
        entity.setEventStatus(1);
        Optional.ofNullable(entity.getLwEventType()).filter(StringUtils::isNotEmpty).flatMap(lwType -> Optional.of(EventTypeEnum.getResultByValue(lwType))).ifPresent(entity::setEventType);
        boolean saveOrUpdate = this.saveOrUpdate((Object)entity);
        if (!saveOrUpdate) {
            return false;
        }
        String id = entity.getId();
        List<BizTrafficControl> controlList = entity.getTrafficControls();
        if (controlList != null && controlList.size() > 0) {
            for (BizTrafficControl bizTrafficControl : controlList) {
                bizTrafficControl.setEventId(id);
            }
            this.controlManager.saveOrUpdateBatch(controlList);
        }
        if ((congestionList = entity.getTrafficCongestions()) != null && congestionList.size() > 0) {
            for (BizTrafficCongestion control : congestionList) {
                control.setEventId(id);
            }
            this.congestionManager.saveOrUpdateBatch(congestionList);
        }
        ArrayList<BizEventHandle> arrayList = new ArrayList<BizEventHandle>();
        int countNode = this.handleManager.countNode(entity.getId(), "1");
        LocalDateTime now = LocalDateTime.now();
        if (countNode < 1) {
            BizEventHandle handleOne = this.setUser(entity.getId(), "1", now);
            arrayList.add(handleOne);
            BizEventHandle handleTwo = this.setUser(entity.getId(), "2", now.plusSeconds(1L));
            arrayList.add(handleTwo);
            this.handleManager.saveBatch(arrayList);
        } else {
            BizEventHandle handleTwo = this.setUser(entity.getId(), "2", now);
            arrayList.add(handleTwo);
            this.handleManager.saveBatch(arrayList);
        }
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            try {
                BizCompensationInfo compensationInfo = new BizCompensationInfo();
                BeanUtils.copyNotNullProperties((Object)((Object)compensationInfo), (Object)((Object)entity));
                compensationInfo.setEventId(entity.getId());
                compensationInfo.setId(null);
                String compensationNo = this.sysIdentityManager.nextId("pcdjh");
                compensationInfo.setCompensationNo(compensationNo);
                this.compensationInfoManager.save((Object)compensationInfo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if ((rescueInfo = entity.getRescueInfos()) != null && !rescueInfo.isEmpty()) {
            rescueInfo.forEach(info -> {
                info.setEventId(entity.getId());
                info.setRoadId(entity.getRoadId());
                info.setRoadName(entity.getRoadName());
                info.setRoadCode(entity.getRoadCode());
                info.setRescueStatus(1);
                this.rescueInfoManager.appoint((BizRescueInfo)((Object)((Object)info)));
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)(rescueId = entity.getRescueId()))) {
            this.setRescueInfo(rescueId, entity.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean cancel(String id) {
        BizEventInfo eventInfo = (BizEventInfo)((Object)super.getById((Serializable)((Object)id)));
        if (eventInfo == null) {
            throw new BaseException("\u672a\u627e\u5230\u8be5\u4e8b\u4ef6!!!");
        }
        int rescueNum = this.rescueInfoManager.countByEventId(id, Arrays.asList(2, 5));
        if (rescueNum > 0) {
            throw new BaseException("\u6551\u63f4\u5355\u5df2\u8fdb\u5165\u5904\u7f6e\u4e2d\u6216\u5df2\u5b8c\u6210\u3002\u5982\u9700\u64a4\u56de\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u70b9\u51fb\u53d6\u6d88!!!");
        }
        if (eventInfo.getEventStatus() == null) {
            throw new BaseException("\u8be5\u4e8b\u4ef6\u672a\u8fdb\u884c\u64cd\u4f5c\uff0c\u65e0\u6cd5\u64a4\u56de!!!");
        }
        if (eventInfo.getEventStatus() > 1) {
            throw new BaseException("\u8be5\u4e8b\u4ef6\u5df2\u8fdb\u5165\u6d41\u7a0b\uff0c\u65e0\u6cd5\u64a4\u56de!!!");
        }
        eventInfo.setEventStatus(-1);
        boolean update = super.updateById((Object)eventInfo);
        if (!update) {
            return false;
        }
        LambdaQueryWrapper rescueInfoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)rescueInfoWrapper.eq(BizRescueInfo::getEventId, (Object)id)).eq(BizRescueInfo::getIsDele, (Object)"0");
        List rescueInfos = this.rescueInfoManager.list((Wrapper)rescueInfoWrapper);
        List<String> resIds = rescueInfos.stream().map(BizRescueInfo::getId).collect(Collectors.toList());
        if (!rescueInfos.isEmpty()) {
            this.rescueInfoManager.removeBath(resIds);
        }
        LambdaQueryWrapper handleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)handleWrapper.eq(BizEventHandle::getEventId, (Object)id)).eq(BizDelModel::getIsDele, (Object)"0");
        this.handleManager.remove((Wrapper)handleWrapper);
        LambdaQueryWrapper compensationInfoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)compensationInfoWrapper.eq(BizCompensationInfo::getEventId, (Object)id)).eq(BizDelModel::getIsDele, (Object)"0");
        this.compensationInfoManager.remove((Wrapper)compensationInfoWrapper);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean end(BizEventInfo t) {
        t.setEventStatus(4);
        boolean update = this.updateById((Object)t);
        if (!update) {
            return false;
        }
        BizEventHandle eventHandle = new BizEventHandle();
        eventHandle.setEventId(t.getId());
        eventHandle.setEventNode("9");
        eventHandle.setHandleTime(LocalDateTime.now());
        return this.handleManager.saveEndInfo(eventHandle);
    }

    @Override
    public EventInfoVO getInfoById(String id) {
        EventInfoVO entity = ((BizEventInfoDao)this.baseMapper).findById(id);
        if (entity == null) {
            return null;
        }
        List<HandInfoVO> hands = this.handleManager.getHands(id);
        entity.setHandles(hands);
        return entity;
    }

    @Override
    public EventInfoVO getFullInfoById(String id) {
        EventInfoVO entity = ((BizEventInfoDao)this.baseMapper).findById(id);
        if (entity == null) {
            return null;
        }
        LambdaQueryWrapper controlWrapper = new LambdaQueryWrapper();
        controlWrapper.eq(BizTrafficControl::getEventId, (Object)id);
        controlWrapper.orderByDesc(BizTrafficControl::getStartTime);
        entity.setTrafficControls(this.controlManager.list((Wrapper)controlWrapper));
        LambdaQueryWrapper congestionWrapper = new LambdaQueryWrapper();
        congestionWrapper.eq(BizTrafficCongestion::getEventId, (Object)id);
        congestionWrapper.orderByDesc(BizTrafficCongestion::getStartTime);
        entity.setTrafficCongestions(this.congestionManager.list((Wrapper)congestionWrapper));
        List<HandInfoVO> hands = this.handleManager.getHands(id);
        entity.setHandles(hands);
        LambdaQueryWrapper compensationInfoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)compensationInfoWrapper.eq(BizCompensationInfo::getEventId, (Object)id)).eq(BizDelModel::getIsDele, (Object)"0");
        BizCompensationInfo compensationInfo = (BizCompensationInfo)((Object)this.compensationInfoManager.getOne((Wrapper)compensationInfoWrapper));
        entity.setCompensationInfo(compensationInfo);
        if (compensationInfo != null) {
            LambdaQueryWrapper compensationDetailsWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)compensationDetailsWrapper.eq(BizCompensationDetails::getCompensationId, (Object)compensationInfo.getId())).eq(BizDelModel::getIsDele, (Object)"0");
            List details = this.detailsManager.list((Wrapper)compensationDetailsWrapper);
            compensationInfo.setCompensationDetails(details);
        }
        LambdaQueryWrapper rescueWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)rescueWrapper.eq(BizRescueInfo::getIsDele, (Object)"0")).eq(BizRescueInfo::getEventId, (Object)id);
        List rescueList = this.rescueInfoManager.list((Wrapper)rescueWrapper);
        entity.setRescueInfos(rescueList);
        List<BizRescueCost> costList = this.costDao.getCostByEvent(id);
        entity.setCosts(costList);
        return entity;
    }

    @Override
    public PageList<BizEventInfo> queryByPower(QueryFilter<BizEventInfo> queryFilter) {
        queryFilter.addFilter("e.is_dele_", (Object)"0", QueryOP.EQUAL);
        String userId = this.baseContext.getCurrentUserId();
        if (userId == null) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return this.executeQuery(queryFilter, this.baseContext, this.currentModelClass(), userId);
    }

    @Override
    public PageList<BizEventInfo> queryByIPage(QueryFilter<BizEventInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizEventInfo> iPage = ((BizEventInfoDao)this.baseMapper).queryByIPage((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    private PageList<BizEventInfo> executeQuery(QueryFilter queryFilter, BaseContext baseContext, Class<BizEventInfo> currentModelClass, String userId) {
        IPage<BizEventInfo> page = baseContext.isAdmin() == false ? ((BizEventInfoDao)this.baseMapper).queryByPower((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, currentModelClass), userId) : ((BizEventInfoDao)this.baseMapper).queryByNo((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(page);
    }

    @Override
    public PageList<BizEventInfo> eventList(QueryFilter<BizEventInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizEventInfo> iPage = ((BizEventInfoDao)this.baseMapper).eventList((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<BizEventInfo> pushTaskList(QueryFilter<BizEventInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("event_status_", Arrays.asList(1, 2, 3), QueryOP.IN);
        IPage<BizEventInfo> iPage = ((BizEventInfoDao)this.baseMapper).pushTaskList((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public CommonResult<JSONObject> countEventByType(QueryFilter<BizEventInfo> queryFilter) {
        JSONObject object = new JSONObject();
        ArrayList vos = new ArrayList();
        List eventInfoList = this.query(queryFilter).getRows();
        if (CollectionUtils.isNotEmpty((Collection)eventInfoList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BizDelModel::getIsDele, (Object)"0");
            wrapper.in(BizCompensationDetails::getEventId, (Collection)eventInfoList.stream().map(BizEventInfo::getId).collect(Collectors.toList()));
            List compensationDetails = this.detailsManager.list((Wrapper)wrapper);
            Map<String, List<BizEventInfo>> eventMap = eventInfoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getRoadId())).collect(Collectors.groupingBy(BizEventInfo::getRoadId));
            Map<String, List<BizCompensationDetails>> compensationDetailMap = compensationDetails.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getEventId())).collect(Collectors.groupingBy(BizCompensationDetails::getEventId));
            CountEventByTypeVO totalVo = new CountEventByTypeVO();
            AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            eventMap.forEach((key, eventInfos) -> {
                CountEventByTypeVO vo = new CountEventByTypeVO();
                vo.setRoadId(((BizEventInfo)((Object)((Object)eventInfos.get(0)))).getRoadId());
                vo.setRoadName(((BizEventInfo)((Object)((Object)eventInfos.get(0)))).getRoadName());
                AtomicReference<BigDecimal> amount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                eventInfos.forEach(eventInfo -> {
                    String resultByValue;
                    switch (resultByValue = EventTypeLwEnum.getResultByValue(eventInfo.getLwEventType())) {
                        case "1": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setMeteorologicalDisaster(vo.getMeteorologicalDisaster() + 1);
                            totalVo.setMeteorologicalDisaster(totalVo.getMeteorologicalDisaster() + 1);
                            break;
                        }
                        case "2": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setGeologicalDisaster(vo.getGeologicalDisaster() + 1);
                            totalVo.setGeologicalDisaster(totalVo.getGeologicalDisaster() + 1);
                            break;
                        }
                        case "3": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setAccidentDisaster(vo.getAccidentDisaster() + 1);
                            totalVo.setAccidentDisaster(totalVo.getAccidentDisaster() + 1);
                            break;
                        }
                        case "4": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setSocialSecurityEvent(vo.getSocialSecurityEvent() + 1);
                            totalVo.setSocialSecurityEvent(totalVo.getSocialSecurityEvent() + 1);
                            break;
                        }
                        case "5": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setConstructEvent(vo.getConstructEvent() + 1);
                            totalVo.setConstructEvent(totalVo.getConstructEvent() + 1);
                            break;
                        }
                        case "6": {
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), amount);
                            this.addAmount((List)compensationDetailMap.get(eventInfo.getId()), totalAmount);
                            vo.setOtherEvent(vo.getOtherEvent() + 1);
                            totalVo.setOtherEvent(totalVo.getOtherEvent() + 1);
                            break;
                        }
                    }
                });
                vo.setRoadAssetLoss(amount.get());
                vos.add(vo);
            });
            totalVo.setRoadAssetLoss(totalAmount.get());
            object.put("data", vos);
            object.put("total", (Object)totalVo);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)object);
    }

    private void addAmount(List<BizCompensationDetails> compensationDetailsList, AtomicReference<BigDecimal> amount) {
        if (CollectionUtils.isNotEmpty(compensationDetailsList)) {
            compensationDetailsList.forEach(compensationDetail -> amount.set(((BigDecimal)amount.get()).add(compensationDetail.getTotle())));
        }
    }

    @Override
    public CommonResult<List<CountEventByTimeVO>> countEventByTime(QueryFilter<BizEventInfo> queryFilter) {
        ArrayList vos = new ArrayList();
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResponseEntity<org.springframework.core.io.Resource> exportLedger(QueryFilter<BizEventInfo> queryFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public EventLedgerVO getEventTaskLedger(QueryFilter<BizEventInfo> queryFilter) {
        List<EventLedgerVO> voList = ((BizEventInfoDao)this.baseMapper).eventLedger((Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            return voList.get(0);
        }
        return new EventLedgerVO();
    }

    @Override
    public void EventLedgerExport(HttpServletResponse response, QueryFilter<BizEventInfo> queryFilter) {
        List<EventLedgerVO> voList = ((BizEventInfoDao)this.baseMapper).eventLedger((Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            EventLedgerVO vo = voList.get(0);
            TemplateExportParams params = new TemplateExportParams("model/eventTask.xlsx", new Integer[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String tempName = "\u7a81\u53d1\u4e8b\u4ef6\u8bb0\u5f55\u5355.xlsx";
            map.put("roadName", vo.getRoadName());
            map.put("createName", vo.getCreateName());
            map.put("receiveTime", vo.getReceiveTime());
            map.put("eventSrcText", vo.getEventSrcText());
            map.put("eventTime", vo.getEventTime());
            map.put("pegSVal", vo.getPegSVal());
            map.put("eventTypeText", vo.getEventTypeText());
            map.put("eventEndTime", vo.getEventTime());
            map.put("enforcementTime", vo.getEnforcementTime());
            map.put("enforcementUser", vo.getEnforcementUser());
            map.put("inspectTime", vo.getInspectTime());
            map.put("rescueTime", vo.getRescueTime());
            map.put("inspectUserName", vo.getInspectUserName());
            map.put("rescueUserName", vo.getRescueUserName());
            map.put("submitContent", vo.getSubmitContent());
            map.put("submitArea", vo.getSubmitArea());
            map.put("memo", vo.getMemo());
            map.put("elapse", vo.getElapse());
            map.put("disposition", vo.getDisposition());
            map.put("hurtInfo", vo.getHurtInfo());
            map.put("reportTime", vo.getReportTime());
            map.put("reportUser", vo.getReportUser());
            map.put("receiveUser", vo.getReceiveUser());
            ExcelUtil.exportExcelWorkbook(tempName, params, map, response);
        }
    }

    @Override
    public PageList<TrafficControlIlboVO> runInfoDayReport(QueryFilter<BizEventInfo> queryFilter) {
        IPage<TrafficControlIlboVO> iPage = ((BizEventInfoDao)this.baseMapper).runInfoIlbo((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public JSONObject runInfoMonthReport(QueryFilter<BizEventInfo> queryFilter) {
        JSONObject object = new JSONObject();
        queryFilter.addFilter("ei.is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<TrafficControlMonthReportVO> iPage = ((BizEventInfoDao)this.baseMapper).runInfoMonthReport((IPage<BizEventInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        object.put("data", (Object)new PageList(iPage));
        TrafficControlMonthReportVO reportVO = ((BizEventInfoDao)this.baseMapper).runInfoTotalReport((Wrapper<BizEventInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        object.put("total", (Object)reportVO);
        return object;
    }

    BizEventHandle setUser(String id, String node, LocalDateTime handleTime) {
        JSONObject team;
        Map sjCzhj = this.sdm.dictMapByCode("sj_czlc");
        BizEventHandle handle = new BizEventHandle();
        handle.setEventId(id);
        handle.setHandleTime(handleTime);
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            handle.setHandleUserId(user.getUserId());
            handle.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            handle.setHandleTeamId(team.getString("teamId"));
            handle.setHandleTeamName(team.getString("teamName"));
        }
        handle.setEventNode(node);
        if (sjCzhj != null && !sjCzhj.isEmpty()) {
            handle.setHandleInfo(ContextUtil.getCurrentUserName() + "\u8fdb\u884c" + ((DictModel)((List)sjCzhj.get(node)).get(0)).getName());
        }
        return handle;
    }

    private void setLngAndLat(BizEventInfo eventInfo) {
        String startPegK = eventInfo.getPegSVal();
        if (StringUtils.isNotEmpty((CharSequence)startPegK)) {
            Double startPeg = BizEventInfoManagerImpl.convertPileNumber(startPegK);
            String roadCode = eventInfo.getRoadCode();
            String direction = "0".equals(eventInfo.getDirection()) ? "1" : eventInfo.getDirection();
            String msgContent = this.pointUtil.mappingPoint("02", roadCode, startPeg, direction);
            if (StringUtils.isNotEmpty((CharSequence)msgContent)) {
                try {
                    JSONObject jsonContent = JSONObject.parseObject((String)msgContent);
                    Double lon = jsonContent.getDouble("lon");
                    Double lat = jsonContent.getDouble("lat");
                    if (lon != null && lat != null) {
                        eventInfo.setLng(String.valueOf(lon));
                        eventInfo.setLat(String.valueOf(lat));
                    }
                }
                catch (JSONException e) {
                    log.error("\u89e3\u6790\u7ecf\u7eac\u5ea6 JSON \u5931\u8d25: {}", (Object)msgContent, (Object)e);
                }
            } else {
                log.error("mappingPoint \u8fd4\u56de\u4e86\u7a7a\u503c\uff0c\u65e0\u6cd5\u83b7\u53d6\u7ecf\u7eac\u5ea6");
            }
        }
    }

    private static Double convertPileNumber(String pileNumber) {
        if ((pileNumber = pileNumber.toUpperCase().replaceAll("^[A-Z]+", "")).matches("\\d+\\+\\d+")) {
            return Double.parseDouble(pileNumber.replace("+", "."));
        }
        return Double.parseDouble(pileNumber);
    }
}

