/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.monitor.manager.BizRankUserManager;
import com.artfess.rescue.monitor.model.BizRankUser;
import com.artfess.rescue.monitor.vo.RankUserVo;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bizRankUser/v1/"})
@Api(tags={"\u6392\u73ed\u7ba1\u7406"})
@ApiGroup(group={"group_biz_rescue"})
public class BizRankUserController
extends BaseController<BizRankUserManager, BizRankUser> {
    @GetMapping(value={"/findMonthArrangeInfo"})
    @ApiOperation(value="\u67e5\u8be2\u67d0\u6708\u7684\u6392\u73ed\u4fe1\u606f")
    public List<RankUserVo> findMonthArrangeInfo(@ApiParam(name="queryDate", value="\u67e5\u8be2\u67d0\u4e00\u4e2a\u6708\u7684\u5f00\u59cb\u65e5\u671f", required=true) @RequestParam(value="queryDate", required=true) String queryDate, @ApiParam(name="orgId", value="\u76d1\u63a7\u4e2d\u5fc3ID", required=true) @RequestParam(value="orgId", required=true) String orgId, @ApiParam(name="rankGroupId", value="\u73ed\u7ec4id") @RequestParam(value="rankGroupId", required=false) String rankGroupId) {
        return ((BizRankUserManager)this.baseService).findMonthArrangeInfo(queryDate, orgId, rankGroupId);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="S-\u5bfc\u5165\u6392\u73ed\u7ba1\u7406\u4fe1\u606f", httpMethod="POST", notes="\u5bfc\u5165\u6392\u73ed\u7ba1\u7406\u4fe1\u606f")
    public CommonResult importRankUsers(@ApiParam(name="file", value="excel\u6a21\u677f\u6587\u4ef6", required=true) MultipartFile file, @ApiParam(name="orgId", value="\u76d1\u63a7\u4e2d\u5fc3ID", required=true) String orgId) {
        return ((BizRankUserManager)this.baseService).importRankUsers(file, orgId);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u65b0\u589e,\u66f4\u65b0\u6392\u73ed\u7ba1\u7406\u4fe1\u606f", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6392\u73ed\u7ba1\u7406\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="BizRankUser", value="\u6536\u8d39\u7ad9\u6392\u73ed\u7ba1\u7406\u4fe1\u606f\u5bf9\u8c61", required=true) @RequestBody BizRankUser rankUser) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtil.isEmpty((String)String.valueOf(rankUser.getId()))) {
            rankUser.setIsDele("0");
            ((BizRankUserManager)this.baseService).save((Object)rankUser);
        } else {
            ((BizRankUserManager)this.baseService).update((Model)rankUser);
            rankUser.setIsDele("0");
            msg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"/saveList"})
    @ApiOperation(value="S-\u6279\u91cf\u65b0\u589e,\u66f4\u65b0\u6392\u73ed\u7ba1\u7406\u4fe1\u606f", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6392\u73ed\u7ba1\u7406\u4fe1\u606f")
    public CommonResult<String> saveList(@ApiParam(name="rankUsers", value="\u6536\u8d39\u7ad9\u6392\u73ed\u7ba1\u7406\u4fe1\u606f\u5bf9\u8c61", required=true) @RequestBody List<BizRankUser> rankUsers) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        for (BizRankUser rankUser : rankUsers) {
            if (StringUtil.isEmpty((String)String.valueOf(rankUser.getId()))) {
                rankUser.setIsDele("0");
                ((BizRankUserManager)this.baseService).save((Object)rankUser);
                continue;
            }
            ((BizRankUserManager)this.baseService).update((Model)rankUser);
            msg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"/get/{id}"})
    @ApiOperation(value="S-\u6392\u73ed\u7ba1\u7406\u8be6\u60c5", httpMethod="POST", notes="\u6392\u73ed\u7ba1\u7406\u8be6\u60c5")
    public BizRankUser get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (BizRankUser)((BizRankUserManager)this.baseService).get((Serializable)((Object)id));
    }

    @PostMapping(value={"/removes"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public CommonResult<String> removes(@ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        List<String> rankIds = Arrays.asList(ids);
        ((BizRankUserManager)this.baseService).removeByIds(rankIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

