/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.rescue.monitor.aop.WebSocketNotify;
import com.artfess.rescue.monitor.dto.EarlyWarningConfirmationDto;
import com.artfess.rescue.monitor.eunms.RefreshType;
import com.artfess.rescue.monitor.manager.BizEarlyWarningManagementManager;
import com.artfess.rescue.monitor.model.BizEarlyWarningManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/monitor/bizEarlyWarningManagement/v1/"})
@Api(tags={"\u8fd0\u884c\u76d1\u6d4b-\u9884\u8b66\u4fe1\u606f\u7ba1\u7406"})
@ApiGroup(group={"group_biz_rescue"})
public class BizEarlyWarningManagementController
extends BaseController<BizEarlyWarningManagementManager, BizEarlyWarningManagement> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    @WebSocketNotify(topic=RefreshType.YJXX, operateType="ADD")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizEarlyWarningManagement t) {
        boolean result = ((BizEarlyWarningManagementManager)this.baseService).save((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    @WebSocketNotify(topic=RefreshType.YJXX, operateType="DELETE")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizEarlyWarningManagementManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    @WebSocketNotify(topic=RefreshType.YJXX, operateType="UPDATE")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizEarlyWarningManagement t) {
        boolean result = ((BizEarlyWarningManagementManager)this.baseService).updateById((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @RequestMapping(value={"downloadMainTempFile"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response) throws Exception {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/warnImport.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u9884\u8b66\u53f0\u8d26\u6a21\u677f\u5bfc\u5165.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @PostMapping(value={"importExcel"})
    @ApiOperation(value="\u5bfc\u5165excel", httpMethod="POST", notes="\u5bfc\u5165excel")
    public CommonResult<String> importData(@RequestParam(value="roadId") String roadId, @RequestParam(value="belongAreaId") String belongAreaId, @RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(BizEarlyWarningManagement.class);
            List list = excelUtil.importExcel(null, file.getInputStream(), Integer.valueOf(3));
            boolean result = ((BizEarlyWarningManagementManager)this.baseService).importExcel(list, roadId, belongAreaId);
            if (!result) {
                throw new IllegalArgumentException("\u7cfb\u7edf\u6ca1\u6709\u68c0\u6d4b\u5230\u4efb\u4f55\u6709\u6548\u6570\u636e");
            }
            return new CommonResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
    }

    @PostMapping(value={"exportExcel"})
    @ApiOperation(value="\u5bfc\u51faexcel", httpMethod="POST", notes="\u5bfc\u51faexcel")
    public void exportExcel(HttpServletResponse response, @RequestBody QueryFilter<BizEarlyWarningManagement> queryFilter) throws Exception {
        ((BizEarlyWarningManagementManager)this.baseService).export(response, queryFilter);
    }

    @GetMapping(value={"regional"})
    @ApiOperation(value="\u6839\u636e\u8def\u6bb5\u67e5\u8be2\u6240\u5728\u533a\u57df", httpMethod="GET", notes="\u6839\u636e\u8def\u6bb5\u67e5\u8be2\u6240\u5728\u533a\u57df")
    public CommonResult getRegional(@RequestParam(value="roadId") String roadId) {
        JSONObject object = ((BizEarlyWarningManagementManager)this.baseService).getRegional(roadId);
        return CommonResult.success((Object)object, (String)"");
    }

    @PostMapping(value={"bhConfirmation"})
    @ApiOperation(value="\u6279\u91cf\u786e\u8ba4", httpMethod="POST", notes="\u6279\u91cf\u786e\u8ba4")
    public CommonResult getRegional(@RequestBody EarlyWarningConfirmationDto dto) {
        boolean result = ((BizEarlyWarningManagementManager)this.baseService).bhConfirmation(dto);
        return new CommonResult(result ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25");
    }

    @PostMapping(value={"publish"})
    @ApiOperation(value="\u786e\u8ba4\u53d1\u5e03", httpMethod="POST", notes="\u786e\u8ba4\u53d1\u5e03")
    @WebSocketNotify(topic=RefreshType.YJXX, operateType="ADD")
    public CommonResult getRegional(@RequestBody BizEarlyWarningManagement e) {
        boolean result = ((BizEarlyWarningManagementManager)this.baseService).publish(e);
        return new CommonResult(result ? "\u53d1\u5e03\u6210\u529f" : "\u53d1\u5e03\u5931\u8d25");
    }

    @PostMapping(value={"getCytq"})
    @ApiOperation(value="\u83b7\u53d6\u5f69\u4e91\u5929\u6c14", httpMethod="POST", notes="\u83b7\u53d6\u5f69\u4e91\u5929\u6c14")
    public void getCytq() {
        ((BizEarlyWarningManagementManager)this.baseService).cyWeather();
    }
}

